package com.ejianc.business.supbusiness.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 消耗材-验收主表
 *
 * @author generator
 */
@ApiModel("消耗材-验收主表")
public class CheckVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long orderId; // 订单主键
    private String orderCode; // 订单编号
    private Long deliveryId; // 发货主键
    private String deliveryCode; // 发货单编号
    private Integer checkState; // 验收状态（0-未验收，1--已验收）
    private String billCode; // 单据编号
    private Long contractId; // 合同主键
    private String contractName; // 合同名称
    private String contractCode; // 合同编码
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long supplierId; // 供应商主键
    private String supplierName; // 供应商名称
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date checkDate; // 验收日期
    private String licensePlate; // 车牌号
    private Integer recordFlag; // 是否补录，0-否，1-是
    private String recordReson; // 补录原因
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String orgCode; // 组织编码
    private Integer checkType; // 验收来源，1-自制验收,2-零星材料验收，3-发货验收
    private Integer signStatus; // 签字状态，0-未签字,1-已签字
    private String memo; // 备注
    private String deliverName; // 供应商联系人
    private Long subContractId; // 分包方ID
    private String subContractName; // 分包方名称
    private String subContractCode; // 分包方编码
    private Long subSupplierId; // 分包合同供应商主键
    private String construction; // 使用部位
    private String parentOrgName; // 父级组织名称
    private String parentOrgCode; // 父级组织编码
    private Long parentOrgId; // 父级组织
    private Integer billState; // 单据状态（审批必须字段）
    private Integer automaticWeigh; // 自动称重设置（0：自动称重，1非自动称重）
    private Integer checkWeighType; // 是否磅单验收  0-否  1-是
    private String billStateName;
    private String recordFlagName;
    private String signStatusName; // 签字状态：0-未签字,1-已签字
    private String checkTypeName; // 验收来源，1-自制验收,2-零星材料验收，3-发货验收
    private Integer supplierSignStatus;
    /**
     * 供方经办人名称
     */
    private String supOperatorName;

    /**
     * 供方经办人手机号
     */
    private String supOperatorPhone;
    /**
     * 供方经办人账号
     */
    private String supOperatorUserCode;

    /**
     * 供方经办人签字时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date supOperateTime;

    private String systemId; // 来源系统主键

    private Long sourceId; // 来源订单主键
    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    @ApiModelProperty("单据推送标识")
    private String billPushFlag;
    private Integer deliveryType; // 发货单类型 1-自制，2-供方推送（订单）

    private String supplierSignStatusName;

    private List<CheckDetailVO> checkDetailList = new ArrayList<>();

    public Integer getCheckWeighType() {
        return checkWeighType;
    }

    public void setCheckWeighType(Integer checkWeighType) {
        this.checkWeighType = checkWeighType;
    }

    public Integer getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public Integer getAutomaticWeigh() {
        return automaticWeigh;
    }

    public void setAutomaticWeigh(Integer automaticWeigh) {
        this.automaticWeigh = automaticWeigh;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }


    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }


    /**
     * 来源业务系统id
     */
    private String sourceSystemId;
    private Long sourceDetailId; // 来源合同明细id
    private String billCodeName;

    public String getBillCodeName() {
        return billCodeName;
    }

    public void setBillCodeName(String billCodeName) {
        this.billCodeName = billCodeName;
    }


    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }


    public String getDeliveryCode() {
        return deliveryCode;
    }

    public void setDeliveryCode(String deliveryCode) {
        this.deliveryCode = deliveryCode;
    }

    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }


    public String getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    /***  协同需要字段 END  ***/

    /**
     * 订单主键
     */
    public Long getOrderId() {
        return orderId;
    }

    /**
     * 订单主键
     */
    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    /**
     * 发货主键
     */
    public Long getDeliveryId() {
        return deliveryId;
    }

    /**
     * 发货主键
     */
    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }

    /**
     * 验收状态（0-未验收，1--已验收）
     */
    public Integer getCheckState() {
        return checkState;
    }

    /**
     * 验收状态（0-未验收，1--已验收）
     */
    public void setCheckState(Integer checkState) {
        this.checkState = checkState;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    /**
     * 合同code
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同code
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 项目code
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目code
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    /**
     * 供应商主键
     */

    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商主键
     */
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    /**
     * 验收日期
     */
    public Date getCheckDate() {
        return checkDate;
    }

    /**
     * 验收日期
     */
    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }

    /**
     * 车牌号
     */
    public String getLicensePlate() {
        return licensePlate;
    }

    /**
     * 车牌号
     */
    public void setLicensePlate(String licensePlate) {
        this.licensePlate = licensePlate;
    }

    /**
     * 是否补录，0-否，1-是
     */
    public Integer getRecordFlag() {
        return recordFlag;
    }

    /**
     * 是否补录，0-否，1-是
     */
    public void setRecordFlag(Integer recordFlag) {
        this.recordFlag = recordFlag;
    }

    /**
     * 补录原因
     */
    public String getRecordReson() {
        return recordReson;
    }

    /**
     * 补录原因
     */
    public void setRecordReson(String recordReson) {
        this.recordReson = recordReson;
    }

    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }


    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    /**
     * 分包合同名称
     */
    public String getSubContractName() {
        return subContractName;
    }

    /**
     * 分包合同名称
     */
    public void setSubContractName(String subContractName) {
        this.subContractName = subContractName;
    }

    /**
     * 分包合同code
     */
    public String getSubContractCode() {
        return subContractCode;
    }

    /**
     * 分包合同code
     */
    public void setSubContractCode(String subContractCode) {
        this.subContractCode = subContractCode;
    }

    /**
     * 分包合同供应商主键
     */
    public Long getSubSupplierId() {
        return subSupplierId;
    }

    /**
     * 分包合同供应商主键
     */
    public void setSubSupplierId(Long subSupplierId) {
        this.subSupplierId = subSupplierId;
    }

    /**
     * 使用部位
     */
    public String getConstruction() {
        return construction;
    }

    /**
     * 使用部位
     */
    public void setConstruction(String construction) {
        this.construction = construction;
    }

    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    /**
     * /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public Integer getCheckType() {
        return checkType;
    }

    public void setCheckType(Integer checkType) {
        this.checkType = checkType;
    }

    public String getDeliverName() {
        return deliverName;
    }

    public void setDeliverName(String deliverName) {
        this.deliverName = deliverName;
    }

    /**
     * 消耗材-验收明细子表
     */
    public List<CheckDetailVO> getCheckDetailList() {
        return checkDetailList;
    }

    /**
     * 消耗材-验收明细子表
     */
    public void setCheckDetailList(List<CheckDetailVO> checkDetailList) {
        this.checkDetailList = checkDetailList;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getSubContractId() {
        return subContractId;
    }

    public void setSubContractId(Long subContractId) {
        this.subContractId = subContractId;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getRecordFlagName() {
        return recordFlagName;
    }

    public void setRecordFlagName(String recordFlagName) {
        this.recordFlagName = recordFlagName;
    }

    public String getSignStatusName() {
        return signStatusName;
    }

    public void setSignStatusName(String signStatusName) {
        this.signStatusName = signStatusName;
    }

    public String getCheckTypeName() {
        return checkTypeName;
    }

    public void setCheckTypeName(String checkTypeName) {
        this.checkTypeName = checkTypeName;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    public void setSupplierSignStatus(Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }

    public String getSupplierSignStatusName() {
        return supplierSignStatusName;
    }

    public void setSupplierSignStatusName(String supplierSignStatusName) {
        this.supplierSignStatusName = supplierSignStatusName;
    }
}
