package com.ejianc.business.supbusiness.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 材料订单主表
 *
 * @author generator
 *
 */
@ApiModel("材料订单主表")
public class OrderVO extends BaseVO {
    private static final long serialVersionUID = 1L;


    private String billCode; // 单据编号
    private Integer billState; // 单据状态（审批必须字段）
    private Long projectId; // 项目
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long parentOrgId; // 上级组织
    private String parentOrgName; // 父级组织名称
    private Long contractId; // 合同主键
    private String contractName; // 合同名称
    private String contractCode; // 合同编号
    private Long supplierId; // 供应商id
    private String supplierName; // 供应商名称
    private String materialName; // 物资名称
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门Id
    private String departmentName; // 经办部门名称
    private Long linkId; // 联系人
    private String linkName; // 联系人名称
    private String linkTelephone; // 联系人电话
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date billDate; // 订单日期
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date expiryDate; // 到货日期
    private String orderNote; // 送货要求
    private String orderAddress; // 送货地址
    private Integer receiveState; // 接收状态（0-待接收,1-全部接收，2-部分接收，3-不予接收）
    private Integer deliverState; // 发货状态（0-待送货，1-部分送货，2-已送货）
    private Integer orderFlag; // 是否开启订单 0-正常，1-已关闭
    private Integer automaticWeigh; // 自动称重设置（0：自动称重，1非自动称重）
    private String platformType; // 磅点类型
    private String platformCode; // 磅点编号
    private Long commitId; // 提交人
    private String receiveReason;//接受原因
    private String systemId; // 来源系统主键
    private String memo;//备注

    private String receiveStateName; // 接收状态（0-待接收,1-全部接收，2-部分接收，3-不予接收）
    private String deliverStateName; // 发货状态（0-待送货，1-部分送货，2-已送货）

    @ApiModelProperty("材料订单子表")
    @SubEntity
    private List<OrderDetailVO> orderDetailList = new ArrayList<>();
    @ApiModelProperty("送货单明细")
    private List<DeliveryVO> deliveryList = new ArrayList<>();

    public Integer getAutomaticWeigh() {
        return automaticWeigh;
    }

    public void setAutomaticWeigh(Integer automaticWeigh) {
        this.automaticWeigh = automaticWeigh;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 上级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 上级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 供应商id
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商id
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门Id
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门Id
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 联系人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getLinkId() {
        return linkId;
    }

    /**
     * 联系人
     */
    @ReferDeserialTransfer
    public void setLinkId(Long linkId) {
        this.linkId = linkId;
    }
    /**
     * 联系人名称
     */
    public String getLinkName() {
        return linkName;
    }

    /**
     * 联系人名称
     */
    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }
    /**
     * 联系人电话
     */
    public String getLinkTelephone() {
        return linkTelephone;
    }

    /**
     * 联系人电话
     */
    public void setLinkTelephone(String linkTelephone) {
        this.linkTelephone = linkTelephone;
    }
    /**
    /**
     * 送货要求
     */
    public String getOrderNote() {
        return orderNote;
    }

    /**
     * 送货要求
     */
    public void setOrderNote(String orderNote) {
        this.orderNote = orderNote;
    }
    /**
     * 送货地址
     */
    public String getOrderAddress() {
        return orderAddress;
    }

    /**
     * 送货地址
     */
    public void setOrderAddress(String orderAddress) {
        this.orderAddress = orderAddress;
    }
    /**
     * 接收状态（0-待接收,1-部分接收，2-全部接收，3-不予接收）
     */
    public Integer getReceiveState() {
        return receiveState;
    }

    /**
     * 接收状态（0-待接收,1-部分接收，2-全部接收，3-不予接收）
     */
    public void setReceiveState(Integer receiveState) {
        this.receiveState = receiveState;
    }
    /**
     * 发货状态（0-待送货，1-部分送货，2-已送货）
     */
    public Integer getDeliverState() {
        return deliverState;
    }

    /**
     * 发货状态（0-待送货，1-部分送货，2-已送货）
     */
    public void setDeliverState(Integer deliverState) {
        this.deliverState = deliverState;
    }
    /**
     * 是否开启订单 0-正常，1-已关闭
     */
    public Integer getOrderFlag() {
        return orderFlag;
    }

    /**
     * 是否开启订单 0-正常，1-已关闭
     */
    public void setOrderFlag(Integer orderFlag) {
        this.orderFlag = orderFlag;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public Date getExpiryDate() {
        return expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    public String getPlatformType() {
        return platformType;
    }

    public void setPlatformType(String platformType) {
        this.platformType = platformType;
    }

    public String getPlatformCode() {
        return platformCode;
    }

    public void setPlatformCode(String platformCode) {
        this.platformCode = platformCode;
    }

    public Long getCommitId() {
        return commitId;
    }

    public void setCommitId(Long commitId) {
        this.commitId = commitId;
    }

    public String getReceiveReason() {
        return receiveReason;
    }

    public void setReceiveReason(String receiveReason) {
        this.receiveReason = receiveReason;
    }

    /**
      * 材料订单子表
      */
      public List<OrderDetailVO> getOrderDetailList() {
         return orderDetailList;
      }
     /**
      * 材料订单子表
      */
     public void setOrderDetailList(List<OrderDetailVO> orderDetailList) {
         this.orderDetailList = orderDetailList;
     }

    public List<DeliveryVO> getDeliveryList() {
        return deliveryList;
    }

    public void setDeliveryList(List<DeliveryVO> deliveryList) {
        this.deliveryList = deliveryList;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getReceiveStateName() {
        return receiveStateName;
    }

    public void setReceiveStateName(String receiveStateName) {
        this.receiveStateName = receiveStateName;
    }

    public String getDeliverStateName() {
        return deliverStateName;
    }

    public void setDeliverStateName(String deliverStateName) {
        this.deliverStateName = deliverStateName;
    }
}
