package com.ejianc.business.supbusiness.common.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.supbusiness.common.util.MessageSendHelper;
import com.ejianc.foundation.message.api.ISmsMessageApi;
import com.ejianc.foundation.message.vo.SmsCheckParam;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DESUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2022/1/25 9:30
 */
@RestController
@RequestMapping("/sms/")
public class SmsController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISmsMessageApi smsMessageApi;

    @Autowired
    private MessageSendHelper messageSendHelper;

    @Autowired
    private IUserApi userApi;

    @PostMapping("checkPhoneCode")
    public CommonResponse<String> checkPhoneCode(@RequestBody SmsCheckParam param) {
        param.setTemplateCode(MessageSendHelper.SMS_TEMPLATE_CODE);
        return smsMessageApi.checkMessage(param);
    }

    /**
     * 协同用户验证
     *
     * @param param
     * @return
     */
    @PostMapping("sendPhoneCode")
    public CommonResponse<String> sendPhoneCode(@RequestBody String param) {
        JSONObject paramJson = JSONObject.parseObject(param);
        String phone = paramJson.getString("phone");
        String secret = paramJson.getString("secret");

        try {
            secret = URLDecoder.decode(secret, "UTF-8");
        } catch (Exception e) {
            logger.error("发送分享连接验证码异常，解析连接参数失败{}，", secret, e);
            return CommonResponse.error("发送验证码失败！");
        }

        String params = DESUtils.decrypt(secret);

        Map<String, String> paraMap = convertToMap(params);

        //强弱协同标识
        Integer weakFlag = Integer.valueOf(paraMap.get("weakFlag"));

        //验证当前用户
        if(weakFlag == 0) {
            //不支持若协同
            //1、判断当前手机号是否对应有用户
            CommonResponse<UserVO> userResp = userApi.findByUserMobile(phone);
            if(!userResp.isSuccess()) {
                logger.error("根据手机号-{}查询匹配用户失败，{}", phone, userResp.getMsg());
                return CommonResponse.error("发送失败，请重试!");
            }
            String supplierTenant = paraMap.get("supplierTenant");
            UserVO user = userResp.getData();
            if(null == user) {
                logger.info("根据手机号-{}未查询匹配用户，且单据不支持弱协同");
                return CommonResponse.error("当前单据不支持弱协同，暂无权限进行此操作！");
            }
            //2、判断当前用户是否为供应商下租户
            if (!StringUtils.equals(supplierTenant, (null != user.getTenantId() ? user.getTenantId().toString() : null))) {
                logger.info("根据手机号对应用户-{}非供应商supplierTenant-{}下用户-{}，且单据不支持弱协同，无操作权限！", phone, supplierTenant, JSONObject.toJSONString(user));
                return CommonResponse.error("当前单据不支持弱协同，暂无权限进行此操作！");
            }
        }

        String result = messageSendHelper.sendPhoneValidCode(phone, secret);
        if(StringUtils.isNotBlank(result)) {
            return CommonResponse.error(result);
        }

        return CommonResponse.success("验证码发送成功！");
    }

    private Map<String, String> convertToMap(String params) {
        Map<String, String> result = new HashMap<>();
        String[] paramPairs = params.split("&");
        String[] tmp = null;
        for(String paramPair : paramPairs) {
            tmp = paramPair.split("=");
            result.put(tmp[0], tmp[1]);
        }

        return result;
    }

}
