package com.ejianc.business.supbusiness.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supbusiness.bean.OrderEntity;
import com.ejianc.business.supbusiness.common.util.BillShareLInkCheckHelper;
import com.ejianc.business.supbusiness.service.IOrderService;
import com.ejianc.business.supbusiness.vo.OrderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 消耗材订单表
 *
 * @author generator
 */
@Controller
@RequestMapping("order")
public class OrderController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private BillShareLInkCheckHelper billShareLInkCheckHelper;

    @Autowired
    private IOrderService service;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> saveOrUpdate(HttpServletRequest request, @RequestParam(value = "file",
            required = false) MultipartFile file) {
        return CommonResponse.success("保存或修改单据成功！", service.saveOrder(request, file));
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrderVO> queryDetail(@RequestParam Long id) {
//        MaterialOrderEntity entity = service.selectById(id);
//        OrderVO vo = BeanMapper.map(entity, OrderVO.class);
        return CommonResponse.success("查询详情数据成功！", service.queryOrderDetail(id));
    }

    @ApiOperation("协同分享查询详情")
//    @GetMapping(value = "/detailBySourceId")
    @RequestMapping(value = "/detailBySourceId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrderVO> detailBySourceId(@RequestParam(value = "id")  String sourceId,
                                                      @RequestParam(value = "tl") String timeout,
                                                      @RequestParam String weakFlag,
                                                      @RequestParam String supplierTenant,
                                                      @RequestParam String secret) {
        OrderEntity orderEntity = service.selectById(sourceId);
        if(null == orderEntity) {
            return CommonResponse.error("单据在系统中不存在或已被删除！");
        }
        String checkMsg = billShareLInkCheckHelper.isShareLinkValid(timeout, sourceId, orderEntity.getSupplierId().toString(), weakFlag, secret, supplierTenant);
        if(StringUtils.isNotBlank(checkMsg)) {
            return CommonResponse.error(checkMsg);
        }
        return CommonResponse.success("查询成功！", BeanMapper.map(orderEntity, OrderVO.class));
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrderVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OrderVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(OrderVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    @RequestMapping(value = "/queryAllList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryAllList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", service.queryAllList(param));
    }

    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", service.queryOrderWaitList(param));
    }

    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryOrderDeliveredList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryOrderDeliveredList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", service.queryOrderDeliveredList(param));
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage<OrderVO> page = service.queryAllList(param);
        List<OrderVO> list = page.getRecords();
        for (OrderVO orderVO : list) {
            if (null != orderVO.getReceiveState()) {
                switch (orderVO.getReceiveState()) {
                    case 0:
                        orderVO.setReceiveStateName("待接收");
                        break;
                    case 2:
                        orderVO.setReceiveStateName("部分接收");
                        break;
                    case 1:
                        orderVO.setReceiveStateName("全部接收");
                        break;
                    case 3:
                        orderVO.setReceiveStateName("不予接收");
                        break;
                }
            }
            if (null != orderVO.getDeliverState()) {
                switch (orderVO.getDeliverState()) {
                    case 0:
                        orderVO.setDeliverStateName("待送货");
                        break;
                    case 1:
                        orderVO.setDeliverStateName("部分送货");
                        break;
                    case 2:
                        orderVO.setDeliverStateName("已送货");
                        break;
                }
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Order-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refMaterialOrderData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> refMaterialOrderData(@RequestParam Integer pageNumber,
                                                                       @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OrderEntity> page = service.queryPage(param, false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @ApiOperation("全部接收、部分接收、不予接收接口")
    @RequestMapping(value = "/saveOrderDelivered", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OrderVO> saveOrderDelivered(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody OrderVO saveOrUpdateVO) {
        return CommonResponse.success("处理成功！", service.saveOrderDelivered(saveOrUpdateVO));
    }

    @ApiOperation("删除单据")
    @RequestMapping(value = "/deleteOrder", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> deleteOrder(@RequestBody OrderVO vo) {
        return CommonResponse.success("处理成功！", service.deleteOrder(vo));
    }

    @ApiOperation("关闭订单")
    @RequestMapping(value = "/updateOrderCloseFlag", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> updateOrderCloseFlag(@RequestBody OrderVO vo) {
        return CommonResponse.success("处理成功！", service.updateOrderCloseFlag(vo));
    }
}
