package com.ejianc.business.supbusiness.enums;

/**
 * 订单接收状态枚举
 */
public enum OrderReceiveStateEnum {

    /** 待接收 */
    WAIT_RECEIVE(0,"待接收"),
    /** 部分接收 */
    PART_RECEIVE(2,"部分接收"),
    /** 全部接收 */
    FULL_RECEIVE(1,"全部接收"),
    /** 不予接收 */
    REFUSE_RECEIVE(3,"不予接收");

    private Integer code;

    private String description;

    OrderReceiveStateEnum(Integer code, String description){
        this.code = code;
        this.description = description;
    };


    /**
     * 获取状态
     * @return 状态
     */
    public Integer getCode() {
        return this.code;
    }

    /**
     * 获取状态注释
     * @return 状态注释
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * 根据状态获取状态枚举
     * @param planState 状态
     * @return 状态枚举
     */
    public static OrderReceiveStateEnum getEnumByStateCode(Integer planState) {
        for (OrderReceiveStateEnum enu : OrderReceiveStateEnum
                .values()) {
            if (enu.getCode().equals(planState)) return enu;
        }
        return null;
    }

    /**
     * 根据状态获取状态注释
     * @param planState 状态
     * @return 状态注释
     */
    public static String getDescriptionByStateCode(Integer planState){
        OrderReceiveStateEnum enu = getEnumByStateCode(planState);
        if (enu != null) return enu.getDescription();
        return null;
    }

}
