package com.ejianc.business.supbusiness.service;

import com.ejianc.business.supbusiness.bean.CheckEntity;
import com.ejianc.business.supbusiness.vo.CheckVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;

/**
 * 消耗材验收单
 *
 * @author generator
 */
public interface ICheckService extends IBaseService<CheckEntity> {

    /**
     * 保存验收单
     *
     * @param request 请求信息
     * @return 保存结果
     */
    boolean saveCheck(HttpServletRequest request);

    /**
     * 删除验收单
     *
     * @param vo 需要删除的验收单
     * @return 删除结果
     */
    boolean deleteCheck(CheckVO vo);

    /**
     * 验收单签字
     *
     * @param checkVO 需要签字的验收单
     * @return 签字结果
     */
    CheckVO saveSupplierSign(CheckVO checkVO);

    /**
     * 根据sourceId查询验收单
     *
     * @param sourceId sourceId
     * @return 验收单明细
     */
    CheckVO queryCheckBySourceId(String sourceId);
}
