package com.ejianc.business.supbusiness.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supbusiness.bean.OrderDetailEntity;
import com.ejianc.business.supbusiness.mapper.OrderDetailMapper;
import com.ejianc.business.supbusiness.service.IDeliveryService;
import com.ejianc.business.supbusiness.service.IOrderDetailService;
import com.ejianc.business.supbusiness.utils.CommonUtils;
import com.ejianc.business.supbusiness.vo.OrderDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 消耗材订单明细表
 *
 * @author generator
 */
@Service("orderDetailService")
public class OrderDetailServiceImpl extends BaseServiceImpl<OrderDetailMapper,
        OrderDetailEntity> implements IOrderDetailService {
    private Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IDeliveryService deliveryService;


    /**
     * 根据订单id删除订单明细（真实删除delete）
     *
     * @param orderId 订单id
     * @return 删除结果
     */
    @Override
    public boolean deleteOrderDetailByOrderId(Long orderId) {
        return baseMapper.deleteOrderDetailByOrderId(orderId);
    }

    /**
     * 查询材料参照
     *
     * @param pageNumber   当前页
     * @param pageSize     分页大小
     * @param condition    查询参数
     * @param searchObject 模糊查询
     * @param searchText   模糊查询
     * @return 查询结果
     */
    @Override
    public IPage<OrderDetailVO> refMaterialOrderDetailData(Integer pageNumber, Integer pageSize,
                                                           String condition, String searchObject,
                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> list = param.getFuzzyFields();
        list.add("materialName");
        list.add("materialTypeName");
        list.add("spec");
        list.add("materialCode");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orderId = null;
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("orderId")) {
                orderId = Long.valueOf(_con.get("orderId").toString());
                param.getParams().put("orderId", new Parameter(QueryParam.EQ, orderId));
            }
            else {
                logger.error("orderId是必传字段，不能为空");
                throw new BusinessException("查询参照失败！");
            }
        }
        else {
            logger.error("orderId是必传字段，不能为空");
            throw new BusinessException("查询参照失败！");
        }
        // 未发货数量大于0
        param.getParams().put("notShippedNumSum", new Parameter(QueryParam.GT, BigDecimal.ZERO));
        // 未送货数量倒序排列
        param.getOrderMap().put("notShippedNumSum", QueryParam.DESC);

        IPage<OrderDetailEntity> page = super.queryPage(param, false);
        List<OrderDetailEntity> detailEntityList = page.getRecords();
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            Map<Long, BigDecimal> deliveryMap = deliveryService.sumDeliveredGroupByDetailId(orderId);
            for (OrderDetailEntity orderDetailEntity : detailEntityList) {
                // 未送货数量，参照每次都需要刷新
                orderDetailEntity.setNotShippedNumSum(orderDetailEntity.getReceiveNumsSum()
                        .subtract(CommonUtils.setBigDecimalDefaultValue(deliveryMap.get(orderDetailEntity.getId()))));
            }
        }

        IPage<OrderDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderDetailVO.class));
        return pageData;
    }
}
