package com.ejianc.business.supbusiness.service.impl;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.supbusiness.bean.DeliveryCarEntity;
import com.ejianc.business.supbusiness.bean.DeliveryDetailEntity;
import com.ejianc.business.supbusiness.bean.DeliveryEntity;
import com.ejianc.business.supbusiness.bean.WeighApplyEntity;
import com.ejianc.business.supbusiness.constant.InteractiveConstants;
import com.ejianc.business.supbusiness.mapper.WeighApplyMapper;
import com.ejianc.business.supbusiness.service.IDeliveryCarService;
import com.ejianc.business.supbusiness.service.IDeliveryDetailService;
import com.ejianc.business.supbusiness.service.IDeliveryService;
import com.ejianc.business.supbusiness.service.IWeighApplyService;
import com.ejianc.business.supbusiness.utils.CommonUtils;
import com.ejianc.business.supbusiness.vo.DeliveryCarVO;
import com.ejianc.business.supbusiness.vo.WeighApplyVO;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.ThirdSystemVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * 过磅申请
 *
 * @author generator
 *
 */
@Service("weighApplyService")
public class WeighApplyServiceImpl extends BaseServiceImpl<WeighApplyMapper, WeighApplyEntity> implements IWeighApplyService{

    private Logger logger = LoggerFactory.getLogger(getClass());
    private static final String WEIXIN_OAUTH_2_URL = "https://api.weixin.qq.com/sns/oauth2/access_token"; // 获取access_token
    private static final String CODE = "Weixin";
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IDeliveryCarService deliveryCarService;
    @Autowired
    private IThirdSystemApi thirdSystemApi;


    @Override
    public WeighApplyVO saveOrUpdate(WeighApplyVO saveOrUpdateVO) {
        WeighApplyEntity entity = fullAddData(saveOrUpdateVO);
        entity.setId(IdWorker.getId());
        entity.setApplyDate(new Date());
        entity.setOtherId(entity.getDeliveryId() + "@@" + entity.getDeliveryDetailId() + "@@" + entity.getId() + "@@" + entity.getMaterialId());
        saveOrUpdate(entity);

        logger.info("开始通知施工方过磅申请信息>>>>>>>>>>>>>>>>>>>");
//        String url = pushMaterialDelivery;
        String url = InteractiveConstants.PUSH_WEIGH_APPLY;
        WeighApplyVO tbVO = BeanMapper.map(entity, WeighApplyVO.class);
        tbVO.setPcCarInfoFlag(false);
        String postData = JSONObject.toJSONString(tbVO);
        String systemId = entity.getSystemId();
        logger.info("发送参数===url:{},postData:[{}],systemId:{}", url, postData, systemId);
        CommonResponse<String> commonResponse = systemDataPushService
                .exchangeDataWithThirdSystem(url, RequestMethod.POST, postData, systemId);
        CommonUtils.checkCommonResponse(commonResponse, logger);
        logger.info("通知施工方发货单信息结束<<<<<<<<<<<<<<<<<<<<");
        return BeanMapper.map(entity, WeighApplyVO.class);
    }

    @Override
    public WeighApplyVO addyzPCWeighApply(DeliveryCarVO deliveryCarVO) {
        //查询单据信息
        WeighApplyEntity entity = fullPcAddData(deliveryCarVO);
        entity.setId(IdWorker.getId());
        entity.setApplyDate(new Date());
        entity.setOtherId(entity.getDeliveryId() + "@@" + entity.getDeliveryDetailId() + "@@" + entity.getId() + "@@" + entity.getMaterialId());
        saveOrUpdate(entity);

        logger.info("开始通知施工方过磅申请信息>>>>>>>>>>>>>>>>>>>");
//        String url = pushMaterialDelivery;
        String url = InteractiveConstants.PUSH_WEIGH_APPLY;
        WeighApplyVO tbVO = BeanMapper.map(entity, WeighApplyVO.class);
        tbVO.setPcCarInfoFlag(true);
        String postData = JSONObject.toJSONString(tbVO);
        String systemId = entity.getSystemId();
        logger.info("发送参数===url:{},postData:[{}],systemId:{}", url, postData, systemId);
        CommonResponse<String> commonResponse = systemDataPushService
                .exchangeDataWithThirdSystem(url, RequestMethod.POST, postData, systemId);
        CommonUtils.checkCommonResponse(commonResponse, logger);
        logger.info("通知施工方发货单信息结束<<<<<<<<<<<<<<<<<<<<");
        //提交成功修改状态
        LambdaUpdateWrapper<DeliveryCarEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(DeliveryCarEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
        updateWrapper.set(DeliveryCarEntity::getWeighApplyId, entity.getId());
        updateWrapper.eq(DeliveryCarEntity::getId, deliveryCarVO.getId());
        deliveryCarService.update(updateWrapper);
        return BeanMapper.map(entity, WeighApplyVO.class);
    }

    @Override
    public List<String> queryCarNumRecord(String openid) {
        return baseMapper.queryCarNumRecord(openid);
    }

    @Override
    public WeighApplyVO queryLastDetail(String openid) {
        LambdaQueryWrapper<WeighApplyEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(WeighApplyEntity::getOpenid, openid);
        queryWrapper.orderByDesc(WeighApplyEntity::getApplyDate);
        queryWrapper.last("limit 1");
        WeighApplyEntity weighApplyEntity = getOne(queryWrapper, false);
        return null != weighApplyEntity ? BeanMapper.map(weighApplyEntity, WeighApplyVO.class) : null;
    }

    @Override
    public WeighApplyVO testPush(Long id) {
        WeighApplyEntity entity = selectById(id);
        entity.setSystemId(deliveryService.selectById(entity.getDeliveryId()).getSystemId());
        logger.info("开始通知施工方过磅申请信息>>>>>>>>>>>>>>>>>>>");
        String url = InteractiveConstants.PUSH_WEIGH_APPLY;
        WeighApplyVO tbVO = BeanMapper.map(entity, WeighApplyVO.class);
        tbVO.setPcCarInfoFlag(false);
        String postData = JSONObject.toJSONString(tbVO);
        String systemId = entity.getSystemId();
        logger.info("发送参数===url:{},postData:[{}],systemId:{}", url, postData, systemId);
        CommonResponse<String> commonResponse = systemDataPushService
                .exchangeDataWithThirdSystem(url, RequestMethod.POST, postData, systemId);
        CommonUtils.checkCommonResponse(commonResponse, logger);
        logger.info("通知施工方发货单信息结束<<<<<<<<<<<<<<<<<<<<");
        return BeanMapper.map(entity, WeighApplyVO.class);
    }

    @Override
    public String getOpenId(String code) {
        Assert.hasText(code, "临时登录凭证不能为空！");

        // 1、查询微信公众号配置信息
        CommonResponse<ThirdSystemVO> thirdSystemResponse = thirdSystemApi.getOneByCode(CODE);
        if (!thirdSystemResponse.isSuccess()) {
            throw new BusinessException("查询微信小程序配置信息失败，失败原因：" + thirdSystemResponse.getMsg());
        }
        ThirdSystemVO thirdSystemVO = thirdSystemResponse.getData();
        String configInfo = thirdSystemVO.getConfigInfo();
        JSONObject configJson = JSON.parseObject(configInfo);
        String appId = configJson.getString("appid");
        String secret = configJson.getString("secret");

        // 2、公众号
        HashMap<String, Object> paramMap = new HashMap<>();
        paramMap.put("appid", appId);
        paramMap.put("secret", secret);
        paramMap.put("code", code);
        paramMap.put("grant_type", "authorization_code");

        HttpResponse response = HttpUtil.createGet(WEIXIN_OAUTH_2_URL)
                .form(paramMap).execute();
        if (!response.isOk()) {
            throw new BusinessException("请求失败！");
        }
        JSONObject jsonObject = JSON.parseObject(response.body());
        if (jsonObject.containsKey("errcode")) {
            throw new BusinessException("获取openid失败，失败原因：" + jsonObject.getString("errmsg"));
        }
        return jsonObject.getString("openid");
    }

    //pc端车次信息
    private WeighApplyEntity fullPcAddData(DeliveryCarVO deliveryCarVO){
        WeighApplyEntity entity = new WeighApplyEntity();
        DeliveryEntity delivery = deliveryService.selectById(deliveryCarVO.getDeliveryId());
        BeanUtils.copyProperties(delivery, entity);

        DeliveryCarEntity deliveryInfoCar = deliveryCarService.selectById(deliveryCarVO.getDeliveryDetailId());
        BeanUtils.copyProperties(deliveryInfoCar, entity);
        entity.setMaterialAmount(deliveryInfoCar.getMaterialAmount());
        entity.setCarNumber(deliveryInfoCar.getDeliveryCarNumber());
        entity.setUpdateUserCode(null);
        entity.setUpdateTime(null);
        entity.setSystemId(delivery.getSystemId());
        return entity;
    }

    /**
     * 补全新增数据
     * @param weighApplyVO
     * @return
     */
    private WeighApplyEntity fullAddData(WeighApplyVO weighApplyVO){
        DeliveryEntity delivery = deliveryService.selectById(weighApplyVO.getDeliveryId());

        WeighApplyEntity entity = new WeighApplyEntity();
        BeanUtils.copyProperties(delivery, entity);
        entity.setDeliveryDetailId(weighApplyVO.getDeliveryDetailId());
        entity.setOpenid(weighApplyVO.getOpenid());
        entity.setCarNumber(weighApplyVO.getCarNumber());
        entity.setCarSerial(weighApplyVO.getCarSerial());
        entity.setSystemId(delivery.getSystemId());

        DeliveryDetailEntity deliveryInfo = deliveryDetailService.selectById(entity.getDeliveryDetailId());
        BeanUtils.copyProperties(deliveryInfo, entity);
        entity.setUpdateUserCode(null);
        entity.setUpdateTime(null);
        return entity;
    }
}
