package com.ejianc.business.cwdataexchange.PMContractPush.api;

import com.ejianc.business.cwdataexchange.PMContractPush.hystrix.PMContractHystrix;
import com.ejianc.business.cwdataexchange.PMContractPush.vo.PMContractVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * PM合同API
 */
@FeignClient(name = "zzyj-cwdataexchange-web", url = "${common.env.feign-client-url}", path = "zzyj-cwdataexchange-web", fallback = PMContractHystrix.class)
public interface IPMContractApi {

    // 新增
    @PostMapping(value = "/api/PMContractPush/saveContract")
     CommonResponse<PMContractVO> saveContract(@RequestBody PMContractVO vo);


    @RequestMapping(value = "/api/PMContractPush/queryDetail", method = RequestMethod.GET)
     CommonResponse<List<PMContractVO>> queryDetail(@RequestParam String contractId, @RequestParam Integer zgbz);

    @RequestMapping(value = "/api/PMContractPush/updateContract", method = RequestMethod.GET)
     CommonResponse<List<String>> updateContract(@RequestParam String contractId,@RequestParam Integer zgbz);

}
