package com.ejianc.business.cwdataexchange.PMContractPush.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.cwdataexchange.PMContractPush.bean.PMContractEntity;
import com.ejianc.business.cwdataexchange.PMContractPush.service.IPMContractService;
import com.ejianc.business.cwdataexchange.PMContractPush.vo.PMContractVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * PM合同推送
 *
 * @author Ssunyj
 */
@RestController
@RequestMapping("/api/PMContractPush")
public class PMJContractController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPMContractService service;


    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<PMContractVO>> queryDetail(@RequestParam String contractId,@RequestParam Integer zgbz) {
        List<PMContractVO> listRes = new ArrayList<>();
        List<PMContractEntity> list = service.list(
                new QueryWrapper<PMContractEntity>()
                        .eq("HTID", contractId)
                        .eq("DR",0)
                        .eq("ZGBZ",zgbz)

        );
        if(CollectionUtils.isNotEmpty(list)){
            listRes = BeanMapper.mapList(list, PMContractVO.class);
        }
        logger.info("查询财务中间表数据：参数contractId；{},返回值：{}",contractId,list.toString());
        return CommonResponse.success("查询详情数据成功！",listRes);
    }


    @PostMapping(value = "/saveContract")
    public CommonResponse<PMContractVO> saveContract(@RequestBody PMContractVO contractVO){
        return service.saveContract(contractVO);
    }


    @RequestMapping(value = "/updateContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<String>> updateContract(@RequestParam String contractId,@RequestParam Integer zgbz) {
        if(StringUtils.isNotEmpty(contractId)) {
            boolean b = service.updateEntity(contractId,zgbz);
            if (b) {
                return CommonResponse.success("修改数据成功！");
            } else {
                return CommonResponse.error("修改数据失败！");
            }
        }
        return CommonResponse.error("输入合同id为空："+contractId);
    }

}
