package com.ejianc.business.cwdataexchange.PMContractPush.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.cwdataexchange.PMContractPush.bean.PMContractEntity;
import com.ejianc.business.cwdataexchange.PMContractPush.mapper.PMContractMapper;
import com.ejianc.business.cwdataexchange.PMContractPush.service.IPMContractService;
import com.ejianc.business.cwdataexchange.PMContractPush.vo.PMContractVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * PM费用间接费
 *
 * @author sunyj
 */
@Service("PMContractService")
public class PMContractServiceImpl extends BaseServiceImpl<PMContractMapper, PMContractEntity> implements IPMContractService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<PMContractVO> saveContract(PMContractVO pmContractVO) {
        logger.info("合同推送财务---PMContractServiceImpl---saveContract方法--begin，pmContractVO={}", pmContractVO.toString());

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        // 校验数据维度是否为空
//        CommonResponse<PMContractVO> checkRes = isNullDimensions(pmContractVO);
//        if (checkRes != null) {
//            return checkRes;
//        }
        //设置id
        pmContractVO.setId(String.valueOf(IdWorker.getId()));
        //引用标识(0表示否）
        pmContractVO.setYybs(0);
        //设置创建时间
        pmContractVO.setCreateTime(sdf.format(new Date()));
        //设置更新时间（保存操作，更新时间为空）
        pmContractVO.setUpdateTime(null);
        //删除标识
        pmContractVO.setDr(0);

        PMContractEntity saveEntity = BeanMapper.map(pmContractVO, PMContractEntity.class);
        super.saveOrUpdate(saveEntity,false);
        return CommonResponse.success("推送财务中间库成功",pmContractVO);
    }

    @Override
    public boolean updateEntity(String contractId,Integer zgbz) {
        LambdaUpdateWrapper<PMContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(PMContractEntity::getContractId,contractId);
        updateWrapper.eq(PMContractEntity::getZgbz,zgbz);
        updateWrapper.set(PMContractEntity::getDr,1);
        return super.update(updateWrapper);
    }

    // 校验推送的合同数据
    private CommonResponse<PMContractVO> isNullDimensions(PMContractVO pmContractVO) {
        if (StringUtils.isBlank(pmContractVO.getContractId())){
            logger.error("本次工资支付申请id不能为空，推送财务中间库失败，pMSalaryPayApplyVO-{}", pmContractVO.toString());
            return CommonResponse.error("本次工资支付申请id不能为空，推送财务中间库失败，请检查数据！");
        }
        return null;
    }
}
