package com.ejianc.business.financeintegration.PMPerformance.api;

import com.ejianc.business.financeintegration.PMPerformance.hystrix.PMPerformanceReturnHystrix;
import com.ejianc.business.financeintegration.PMPerformance.vo.PMPerformanceReturnVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 履约保证金API
 */
@FeignClient(name = "zzyj-financeintegration-web", url = "${common.env.feign-client-url}", path = "zzyj-financeintegration-web", fallback = PMPerformanceReturnHystrix.class)
public interface IPMPerformanceReturnApi {


    // 退款单弃审/关闭
    @PostMapping(value = "/api/PMPerformanceReturn/performanceReturnAbandonOrClose")
    CommonResponse<PMPerformanceReturnVO> performanceReturnAbandonOrClose(@RequestBody PMPerformanceReturnVO vo);

    // 退款单推送
    @PostMapping(value = "/api/PMPerformanceReturn/performanceReturnTakeEffect")
    CommonResponse<PMPerformanceReturnVO> performanceReturnTakeEffect(@RequestBody List<PMPerformanceReturnVO> vo);


}
