package com.ejianc.business.financeintegration.PMPerformance.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.financeintegration.PMPerformance.hystrix.PMPerformanceHystrix;
import com.ejianc.business.financeintegration.PMPerformance.vo.PMPerformanceVO;
import com.ejianc.business.financeintegration.PMSalary.hystrix.PMSalarySystemHystrix;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMSbgjjgsVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 履约保证金API
 */
@FeignClient(name = "zzyj-financeintegration-web", url = "${common.env.feign-client-url}", path = "zzyj-financeintegration-web", fallback = PMPerformanceHystrix.class)
public interface IPMPerformanceApi {


    // 扣款单弃审/关闭
    @PostMapping(value = "/api/PMPerformance/performanceAbandonOrClose")
    CommonResponse<PMPerformanceVO> performanceAbandonOrClose(@RequestBody PMPerformanceVO vo);

    // 扣款单推送
    @PostMapping(value = "/api/PMPerformance/performanceTakeEffect")
    CommonResponse<PMPerformanceVO> performanceTakeEffect(@RequestBody List<PMPerformanceVO> vo);


}
