package com.ejianc.business.financeintegration.PMSalary.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.financeintegration.PMPayApply.hystrix.PMSalaryPayApplyHystrix;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMSalaryPayApplyVO;
import com.ejianc.business.financeintegration.PMSalary.hystrix.PMSalarySystemHystrix;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzDetailVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMSbgjjgsVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 薪资系统API
 */
@FeignClient(name = "zzyj-financeintegration-web", url = "${common.env.feign-client-url}", path = "zzyj-financeintegration-web", fallback = PMSalarySystemHystrix.class)
public interface IPMSalarySystemApi {

    // 社保公积金生效
    @PostMapping(value = "/api/PMSalarySystemApply/sbTakeEffect")
    CommonResponse<PMSbgjjgsVO> sbTakeEffect(@RequestBody List<PMSbgjjgsVO> vo);

    // 工资弃审/关闭
    @PostMapping(value = "/api/PMSalarySystemApply/salaryAbandonOrClose")
    CommonResponse<PMGzVO> salaryAbandonOrClose(@RequestBody PMGzVO vo);

    // 工资生效
    @PostMapping(value = "/api/PMSalarySystemApply/salaryTakeEffect")
    CommonResponse<PMGzVO> salaryTakeEffect(@RequestBody List<PMGzVO> vo);



    // 查询社保公积金列表
    @PostMapping(value = "/api/PMSalarySystemApply/queryList")
    CommonResponse<JSONObject> queryList(@RequestBody QueryParam param);

    // 查询社保公积金列表
    @PostMapping(value = "/api/PMSalarySystemApply/queryGZList")
    CommonResponse<JSONObject> queryGZList(@RequestBody QueryParam param);

    // 查询工资明细
    @PostMapping(value = "/api/PMSalarySystemApply/querySalaryDetailList")
    CommonResponse<JSONObject> querySalaryDetailList(@RequestBody QueryParam param);


    // 根据id修改工资明细子表的支付状态和修改时间
    @PostMapping(value = "/api/PMSalarySystemApply/changeSalaryDetailState")
    CommonResponse<JSONObject> changeSalaryDetailState(@RequestBody List<String> vo);
}
