/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.financeintegration.PMPayApply.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.financeintegration.PMPayApply.bean.PMPayApplyEntity;
import com.ejianc.business.financeintegration.PMPayApply.mapper.PMPayApplyMapper;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMPayApplyService;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMPayApplyVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="PMPayApplyService")
public class PMPayApplyServiceImpl
extends BaseServiceImpl<PMPayApplyMapper, PMPayApplyEntity>
implements IPMPayApplyService {
    @Autowired
    private PMPayApplyMapper pmPayApplyMapper;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<PMPayApplyVO> takeEffect(PMPayApplyVO paramVO) {
        BigDecimal subtract;
        BigDecimal alreadyDataCanPayMny;
        BigDecimal alreadyDataTotalPaidMny;
        this.logger.info("zzyj-financeintegration---PMPayApplyServiceImpl---takeEffect\u65b9\u6cd5--begin\uff0cparamVO={}", (Object)paramVO);
        Integer isContract = paramVO.getIsContract();
        BigDecimal curApplyMny = paramVO.getCurApplyMny();
        String projectId = paramVO.getProjectId();
        String supplierId = paramVO.getSupplierId();
        String contractRegisterId = paramVO.getContractRegisterId();
        String payeeId = paramVO.getPayeeId();
        CommonResponse<PMPayApplyVO> isRightContractIdRes = this.isRightContractRegisterId(paramVO, isContract, contractRegisterId);
        if (isRightContractIdRes != null) {
            return isRightContractIdRes;
        }
        if (curApplyMny == null) {
            this.logger.error("\u672c\u6b21\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0cparamVO-{}", (Object)paramVO.toString());
            return CommonResponse.error((String)"\u672c\u6b21\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01");
        }
        CommonResponse<PMPayApplyVO> checkRes = this.isNullDimensions(paramVO);
        if (checkRes != null) {
            return checkRes;
        }
        PMPayApplyEntity saveEntity = new PMPayApplyEntity();
        List<PMPayApplyEntity> alreadyDataList = this.getByDataDimensions(paramVO);
        if (CollectionUtils.isEmpty(alreadyDataList)) {
            this.setDimensions(projectId, supplierId, contractRegisterId, payeeId, saveEntity);
            saveEntity.setTotalPayableMny(curApplyMny);
            saveEntity.setTotalPaidMny(BigDecimal.ZERO);
            saveEntity.setCanPayMny(curApplyMny);
            saveEntity.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            CommonResponse<PMPayApplyVO> doSaveRes = this.doSave(saveEntity, "add");
            this.logger.info("zzyj-financeintegration---PMPayApplyServiceImpl---takeEffect\u65b9\u6cd5--end\uff0c\u7ed3\u679c-{}", (Object)JSONObject.toJSONString(doSaveRes, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            return doSaveRes;
        }
        if (alreadyDataList.size() > 1) {
            this.logger.error("\u6839\u636e\u6570\u636e\u7ef4\u5ea6\uff08\u9879\u76eeID\u3001\u4f9b\u5e94\u5546ID\u3001\u5408\u540c\u767b\u8bb0ID\u3001\u6536\u6b3e\u65b9ID\uff09\u67e5\u8be2\u7684\u6570\u636e\u6709\u8bef\uff0c\u540c\u4e00\u6570\u636e\u7ef4\u5ea6\u4e0b\u53ea\u80fd\u6709\u4e00\u6761\u6570\u636e\uff0c\u67e5\u8be2\u5230\u7684\u6570\u636e\u5df2\u8d85\u8fc7\u4e00\u6761\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff01\u67e5\u8be2\u7ed3\u679c-{}", (Object)alreadyDataList.toString());
            return CommonResponse.error((String)"\u6839\u636e\u6570\u636e\u7ef4\u5ea6\uff08\u9879\u76eeID\u3001\u4f9b\u5e94\u5546ID\u3001\u5408\u540c\u767b\u8bb0ID\u3001\u6536\u6b3e\u65b9ID\uff09\u67e5\u8be2\u7684\u6570\u636e\u6709\u8bef\uff0c\u540c\u4e00\u6570\u636e\u7ef4\u5ea6\u4e0b\u53ea\u80fd\u6709\u4e00\u6761\u6570\u636e\uff0c\u67e5\u8be2\u5230\u7684\u6570\u636e\u5df2\u8d85\u8fc7\u4e00\u6761\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff01");
        }
        PMPayApplyEntity alreadyData = alreadyDataList.get(0);
        BigDecimal alreadyDataTotalPayableMny = alreadyData.getTotalPayableMny();
        if (alreadyDataTotalPayableMny == null) {
            alreadyDataTotalPayableMny = BigDecimal.ZERO;
            alreadyData.setTotalPayableMny(BigDecimal.ZERO);
        }
        if ((alreadyDataTotalPaidMny = alreadyData.getTotalPaidMny()) == null) {
            alreadyDataTotalPaidMny = BigDecimal.ZERO;
            alreadyData.setTotalPaidMny(BigDecimal.ZERO);
        }
        if ((alreadyDataCanPayMny = alreadyData.getCanPayMny()) == null) {
            alreadyDataCanPayMny = BigDecimal.ZERO;
            alreadyData.setCanPayMny(BigDecimal.ZERO);
        }
        if ((subtract = alreadyDataTotalPayableMny.subtract(alreadyDataTotalPaidMny)).compareTo(alreadyDataCanPayMny) < 0) {
            this.logger.error("\u67e5\u8be2\u5230\u7684\u6570\u636e\u4e2d\uff0c\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u3010" + alreadyDataTotalPayableMny + "\u3011 - \u7d2f\u8ba1\u5df2\u4ed8\u91d1\u989d\u3010" + alreadyDataTotalPaidMny + "\u3011 < \u53ef\u652f\u4ed8\u91d1\u989d\u3010" + alreadyDataCanPayMny + "\u3011\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0cparamVO-{}\uff0c\u67e5\u8be2\u7ed3\u679c-{}", (Object)paramVO.toString(), (Object)alreadyDataList.toString());
            return CommonResponse.error((String)("\u67e5\u8be2\u5230\u7684\u6570\u636e\u4e2d\uff0c\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u3010" + alreadyDataTotalPayableMny + "\u3011 - \u7d2f\u8ba1\u5df2\u4ed8\u91d1\u989d\u3010" + alreadyDataTotalPaidMny + "\u3011 < \u53ef\u652f\u4ed8\u91d1\u989d\u3010" + alreadyDataCanPayMny + "\u3011\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01"));
        }
        saveEntity.setTotalPayableMny(alreadyDataTotalPayableMny.add(curApplyMny));
        saveEntity.setCanPayMny(alreadyDataCanPayMny.add(curApplyMny));
        saveEntity.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        this.setDimensions(projectId, supplierId, contractRegisterId, payeeId, saveEntity);
        CommonResponse<PMPayApplyVO> doSaveRes = this.doSave(saveEntity, "update");
        this.logger.info("zzyj-financeintegration---PMPayApplyServiceImpl---takeEffect\u65b9\u6cd5--end\uff0c\u7ed3\u679c-{}", (Object)JSONObject.toJSONString(doSaveRes, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return doSaveRes;
    }

    @Override
    public CommonResponse<PMPayApplyVO> abandonOrClose(PMPayApplyVO paramVO) {
        BigDecimal subtract;
        BigDecimal alreadyDataCanPayMny;
        BigDecimal alreadyDataTotalPaidMny;
        this.logger.info("zzyj-financeintegration---PMPayApplyServiceImpl---abandonOrClose\u65b9\u6cd5--begin\uff0cparamVO={}", (Object)paramVO);
        Integer type = paramVO.getType();
        Integer isContract = paramVO.getIsContract();
        String projectId = paramVO.getProjectId();
        String supplierId = paramVO.getSupplierId();
        String contractRegisterId = paramVO.getContractRegisterId();
        String payeeId = paramVO.getPayeeId();
        BigDecimal curApplyMny = paramVO.getCurApplyMny();
        BigDecimal curReleaseMny = paramVO.getCurReleaseMny();
        CommonResponse<PMPayApplyVO> isRightContractIdRes = this.isRightContractRegisterId(paramVO, isContract, contractRegisterId);
        if (isRightContractIdRes != null) {
            return isRightContractIdRes;
        }
        if (type == null) {
            this.logger.error("PM\u4ed8\u6b3e\u7533\u8bf7\u7684\u7c7b\u578b\u6807\u8bc6\uff081-\u5f03\u5ba1\u30012-\u5173\u95ed\uff09\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0cparamVO-{}", (Object)paramVO.toString());
            return CommonResponse.error((String)"PM\u4ed8\u6b3e\u7533\u8bf7\u7684\u7c7b\u578b\u6807\u8bc6\uff081-\u5f03\u5ba1\u30012-\u5173\u95ed\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff01");
        }
        if (type != 1 && type != 2) {
            this.logger.error("PM\u4ed8\u6b3e\u7533\u8bf7\u7684\u7c7b\u578b\u6807\u8bc6\uff081-\u5f03\u5ba1\u30012-\u5173\u95ed\uff09\u9519\u8bef\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0cparamVO-{}", (Object)paramVO.toString());
            return CommonResponse.error((String)"PM\u4ed8\u6b3e\u7533\u8bf7\u7684\u7c7b\u578b\u6807\u8bc6\uff081-\u5f03\u5ba1\u30012-\u5173\u95ed\uff09\u9519\u8bef\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff01");
        }
        if (type == 1 && curApplyMny == null) {
            this.logger.error("\u672c\u6b21\u7533\u8bf7\u91d1\u989d\u4e3a\u7a7a\uff0cparamVO-{}", (Object)paramVO.toString());
            return CommonResponse.error((String)"\u672c\u6b21\u7533\u8bf7\u91d1\u989d\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01");
        }
        if (type == 2 && curReleaseMny == null) {
            this.logger.error("\u672c\u6b21\u91ca\u653e\u7533\u8bf7\u91d1\u989d\u4e3a\u7a7a\uff0cparamVO-{}", (Object)paramVO.toString());
            return CommonResponse.error((String)"\u672c\u6b21\u91ca\u653e\u7533\u8bf7\u91d1\u989d\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01");
        }
        CommonResponse<PMPayApplyVO> checkRes = this.isNullDimensions(paramVO);
        if (checkRes != null) {
            return checkRes;
        }
        PMPayApplyEntity saveEntity = new PMPayApplyEntity();
        List<PMPayApplyEntity> alreadyDataList = this.getByDataDimensions(paramVO);
        if (CollectionUtils.isEmpty(alreadyDataList)) {
            this.logger.error("\u6839\u636e\u6570\u636e\u7ef4\u5ea6\uff08\u9879\u76eeID\u3001\u4f9b\u5e94\u5546ID\u3001\u5408\u540c\u767b\u8bb0ID\u3001\u6536\u6b3e\u5355\u4f4dID\uff09\u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0cparamVO-{}\uff0c\u67e5\u8be2\u7ed3\u679c-{}", (Object)paramVO.toString(), (Object)alreadyDataList.toString());
            return CommonResponse.error((String)"\u6839\u636e\u6570\u636e\u7ef4\u5ea6\uff08\u9879\u76eeID\u3001\u4f9b\u5e94\u5546ID\u3001\u5408\u540c\u767b\u8bb0ID\u3001\u6536\u6b3e\u5355\u4f4dID\uff09\u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff01");
        }
        if (alreadyDataList.size() > 1) {
            this.logger.error("\u6839\u636e\u6570\u636e\u7ef4\u5ea6\uff08\u9879\u76eeID\u3001\u4f9b\u5e94\u5546ID\u3001\u5408\u540c\u767b\u8bb0ID\u3001\u6536\u6b3e\u65b9ID\uff09\u67e5\u8be2\u7684\u6570\u636e\u6709\u8bef\uff0c\u540c\u4e00\u6570\u636e\u7ef4\u5ea6\u4e0b\u53ea\u80fd\u6709\u4e00\u6761\u6570\u636e\uff0c\u67e5\u8be2\u5230\u7684\u6570\u636e\u5df2\u8d85\u8fc7\u4e00\u6761\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff01\uff0cparamVO-{}\uff0c\u67e5\u8be2\u7ed3\u679c-{}", (Object)paramVO.toString(), (Object)alreadyDataList.toString());
            return CommonResponse.error((String)"\u6839\u636e\u6570\u636e\u7ef4\u5ea6\uff08\u9879\u76eeID\u3001\u4f9b\u5e94\u5546ID\u3001\u5408\u540c\u767b\u8bb0ID\u3001\u6536\u6b3e\u65b9ID\uff09\u67e5\u8be2\u7684\u6570\u636e\u6709\u8bef\uff0c\u540c\u4e00\u6570\u636e\u7ef4\u5ea6\u4e0b\u53ea\u80fd\u6709\u4e00\u6761\u6570\u636e\uff0c\u67e5\u8be2\u5230\u7684\u6570\u636e\u5df2\u8d85\u8fc7\u4e00\u6761\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff01");
        }
        PMPayApplyEntity alreadyData = alreadyDataList.get(0);
        BigDecimal alreadyDataTotalPayableMny = alreadyData.getTotalPayableMny();
        if (alreadyDataTotalPayableMny == null) {
            alreadyDataTotalPayableMny = BigDecimal.ZERO;
            alreadyData.setTotalPayableMny(BigDecimal.ZERO);
        }
        if ((alreadyDataTotalPaidMny = alreadyData.getTotalPaidMny()) == null) {
            alreadyDataTotalPaidMny = BigDecimal.ZERO;
            alreadyData.setTotalPaidMny(BigDecimal.ZERO);
        }
        if ((alreadyDataCanPayMny = alreadyData.getCanPayMny()) == null) {
            alreadyDataCanPayMny = BigDecimal.ZERO;
            alreadyData.setCanPayMny(BigDecimal.ZERO);
        }
        if ((subtract = alreadyDataTotalPayableMny.subtract(alreadyDataTotalPaidMny)).compareTo(alreadyDataCanPayMny) < 0) {
            this.logger.error("\u67e5\u8be2\u5230\u7684\u6570\u636e\u4e2d\uff0c\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u3010" + alreadyDataTotalPayableMny + "\u3011 - \u7d2f\u8ba1\u5df2\u4ed8\u91d1\u989d\u3010" + alreadyDataTotalPaidMny + "\u3011 < \u53ef\u652f\u4ed8\u91d1\u989d\u3010" + alreadyDataCanPayMny + "\u3011\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0cparamVO-{}\uff0c\u67e5\u8be2\u7ed3\u679c-{}", (Object)paramVO.toString(), (Object)alreadyDataList.toString());
            return CommonResponse.error((String)("\u67e5\u8be2\u5230\u7684\u6570\u636e\u4e2d\uff0c\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u3010" + alreadyDataTotalPayableMny + "\u3011 - \u7d2f\u8ba1\u5df2\u4ed8\u91d1\u989d\u3010" + alreadyDataTotalPaidMny + "\u3011 < \u53ef\u652f\u4ed8\u91d1\u989d\u3010" + alreadyDataCanPayMny + "\u3011\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01"));
        }
        BigDecimal alreadyDataPayingMny = alreadyData.getPayingMny();
        BigDecimal decimal = BigDecimal.ZERO;
        if (alreadyDataPayingMny != null) {
            decimal = alreadyDataPayingMny;
        }
        if (type == 1) {
            BigDecimal subtractCanPay = alreadyDataCanPayMny.subtract(curApplyMny);
            if (subtractCanPay.compareTo(decimal) < 0) {
                this.logger.error("\u53ef\u652f\u4ed8\u91d1\u989d\u3010" + alreadyDataCanPayMny + "\u3011 - \u672c\u6b21\u4ed8\u6b3e\u7533\u8bf7\u91d1\u989d\u3010" + curApplyMny + "\u3011 < \u5360\u7528\u91d1\u989d\u3010" + decimal + "\u3011\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0cparamVO-{}", (Object)paramVO.toString());
                return CommonResponse.error((String)("\u53ef\u652f\u4ed8\u91d1\u989d\u3010" + alreadyDataCanPayMny + "\u3011 - \u672c\u6b21\u4ed8\u6b3e\u7533\u8bf7\u91d1\u989d\u3010" + curApplyMny + "\u3011 < \u5360\u7528\u91d1\u989d\u3010" + decimal + "\u3011\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff01"));
            }
            BigDecimal subtractPayable = alreadyDataTotalPayableMny.subtract(curApplyMny);
            if (subtractPayable.compareTo(BigDecimal.ZERO) < 0) {
                this.logger.error("\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u3010" + alreadyDataTotalPayableMny + "\u3011 - \u672c\u6b21\u7533\u8bf7\u91d1\u989d\u3010" + curApplyMny + "\u3011 < 0\uff0c\u6b64\u5dee\u503c\u4e0d\u5e94\u5c0f\u4e8e0\uff0c\u6570\u636e\u6709\u8bef\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff0cparamVO-{}", (Object)paramVO.toString());
                return CommonResponse.error((String)("\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u3010" + alreadyDataTotalPayableMny + "\u3011 - \u672c\u6b21\u7533\u8bf7\u91d1\u989d\u3010" + curApplyMny + "\u3011 < 0\uff0c\u6b64\u5dee\u503c\u4e0d\u5e94\u5c0f\u4e8e0\uff0c\u6570\u636e\u6709\u8bef\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01"));
            }
            saveEntity.setTotalPayableMny(subtractPayable);
            if (subtractCanPay.compareTo(BigDecimal.ZERO) < 0) {
                this.logger.error("\u53ef\u652f\u4ed8\u91d1\u989d\u3010" + alreadyDataCanPayMny + "\u3011 - \u672c\u6b21\u7533\u8bf7\u91d1\u989d\u3010" + curApplyMny + "\u3011 < 0\uff0c\u6b64\u5dee\u503c\u4e0d\u5e94\u5c0f\u4e8e0\uff0c\u6570\u636e\u6709\u8bef\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff0cparamVO-{}", (Object)paramVO.toString());
                return CommonResponse.error((String)("\u53ef\u652f\u4ed8\u91d1\u989d\u3010" + alreadyDataCanPayMny + "\u3011 - \u672c\u6b21\u7533\u8bf7\u91d1\u989d\u3010" + curApplyMny + "\u3011 < 0\uff0c\u6b64\u5dee\u503c\u4e0d\u5e94\u5c0f\u4e8e0\uff0c\u6570\u636e\u6709\u8bef\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01"));
            }
            saveEntity.setCanPayMny(subtractCanPay);
        } else {
            BigDecimal subtractRelease = alreadyDataCanPayMny.subtract(curReleaseMny);
            if (subtractRelease.compareTo(decimal) < 0) {
                this.logger.error("\u53ef\u652f\u4ed8\u91d1\u989d\u3010" + alreadyDataCanPayMny + "\u3011 - \u672c\u6b21\u91ca\u653e\u7533\u8bf7\u91d1\u989d\u3010" + curReleaseMny + "\u3011 < \u5360\u7528\u91d1\u989d\u3010" + decimal + "\u3011\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0cparamVO-{}", (Object)paramVO.toString());
                return CommonResponse.error((String)("\u53ef\u652f\u4ed8\u91d1\u989d\u3010" + alreadyDataCanPayMny + "\u3011 - \u672c\u6b21\u91ca\u653e\u7533\u8bf7\u91d1\u989d\u3010" + curReleaseMny + "\u3011 < \u5360\u7528\u91d1\u989d\u3010" + decimal + "\u3011\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff01"));
            }
            BigDecimal subtractPayable = alreadyDataTotalPayableMny.subtract(curReleaseMny);
            if (subtractPayable.compareTo(BigDecimal.ZERO) < 0) {
                this.logger.error("\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u3010" + alreadyDataTotalPayableMny + "\u3011 - \u672c\u6b21\u91ca\u653e\u7533\u8bf7\u91d1\u989d\u3010" + curReleaseMny + "\u3011 < 0\uff0c\u6b64\u5dee\u503c\u4e0d\u5e94\u5c0f\u4e8e0\uff0c\u6570\u636e\u6709\u8bef\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff0cparamVO-{}", (Object)paramVO.toString());
                return CommonResponse.error((String)("\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u3010" + alreadyDataTotalPayableMny + "\u3011 - \u672c\u6b21\u91ca\u653e\u7533\u8bf7\u91d1\u989d\u3010" + curReleaseMny + "\u3011 < 0\uff0c\u6b64\u5dee\u503c\u4e0d\u5e94\u5c0f\u4e8e0\uff0c\u6570\u636e\u6709\u8bef\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01"));
            }
            saveEntity.setTotalPayableMny(subtractPayable);
            if (subtractRelease.compareTo(BigDecimal.ZERO) < 0) {
                this.logger.error("\u53ef\u652f\u4ed8\u91d1\u989d\u3010" + alreadyDataCanPayMny + "\u3011 - \u672c\u6b21\u91ca\u653e\u7533\u8bf7\u91d1\u989d\u3010" + curReleaseMny + "\u3011 < 0\uff0c\u6b64\u5dee\u503c\u4e0d\u5e94\u5c0f\u4e8e0\uff0c\u6570\u636e\u6709\u8bef\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff0cparamVO-{}", (Object)paramVO.toString());
                return CommonResponse.error((String)("\u53ef\u652f\u4ed8\u91d1\u989d\u3010" + alreadyDataCanPayMny + "\u3011 - \u672c\u6b21\u91ca\u653e\u7533\u8bf7\u91d1\u989d\u3010" + curReleaseMny + "\u3011 < 0\uff0c\u6b64\u5dee\u503c\u4e0d\u5e94\u5c0f\u4e8e0\uff0c\u6570\u636e\u6709\u8bef\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01"));
            }
            saveEntity.setCanPayMny(subtractRelease);
        }
        saveEntity.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        this.setDimensions(projectId, supplierId, contractRegisterId, payeeId, saveEntity);
        CommonResponse<PMPayApplyVO> doSaveRes = this.doSave(saveEntity, "update");
        this.logger.info("zzyj-financeintegration---PMPayApplyServiceImpl---abandonOrClose\u65b9\u6cd5--end\uff0c\u7ed3\u679c-{}", (Object)JSONObject.toJSONString(doSaveRes, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return doSaveRes;
    }

    @Override
    public CommonResponse<PMPayApplyVO> writeOff(PMPayApplyVO paramVO) {
        BigDecimal subtract;
        BigDecimal alreadyDataCanPayMny;
        BigDecimal alreadyDataTotalPaidMny;
        this.logger.info("\u4ed8\u6b3e\u7533\u8bf7\u6838\u9500---writeOff\u65b9\u6cd5--begin\uff0cparamVO-{}", (Object)JSONObject.toJSONString((Object)paramVO));
        Integer isContract = paramVO.getIsContract();
        BigDecimal payMnyActual = paramVO.getPayMnyActual();
        String projectId = paramVO.getProjectId();
        String supplierId = paramVO.getSupplierId();
        String contractRegisterId = paramVO.getContractRegisterId();
        String payeeId = paramVO.getPayeeId();
        CommonResponse<PMPayApplyVO> isRightContractIdRes = this.isRightContractRegisterId(paramVO, isContract, contractRegisterId);
        if (isRightContractIdRes != null) {
            return isRightContractIdRes;
        }
        CommonResponse<PMPayApplyVO> checkRes = this.isNullDimensions(paramVO);
        if (checkRes != null) {
            return checkRes;
        }
        if (payMnyActual == null) {
            this.logger.error("\u5b9e\u9645\u652f\u4ed8\u91d1\u989d\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0cparamVO-{}", (Object)JSONObject.toJSONString((Object)paramVO));
            return CommonResponse.error((String)"\u5b9e\u9645\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff01");
        }
        PMPayApplyEntity saveEntity = new PMPayApplyEntity();
        List<PMPayApplyEntity> alreadyDataList = this.getByDataDimensions(paramVO);
        if (CollectionUtils.isEmpty(alreadyDataList)) {
            this.logger.error("\u6839\u636e\u6570\u636e\u7ef4\u5ea6\uff08\u9879\u76eeID-{}\u3001\u4f9b\u5e94\u5546ID-{}\u3001\u5408\u540c\u767b\u8bb0ID-{}\u3001\u6536\u6b3e\u5355\u4f4dID-{}\uff09\u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0cparamVO-{}\uff0c\u67e5\u8be2\u7ed3\u679c-{}", new Object[]{paramVO.getProjectId(), paramVO.getSupplierId(), paramVO.getContractRegisterId(), paramVO.getPayeeId(), JSONObject.toJSONString((Object)paramVO), alreadyDataList.toString()});
            return CommonResponse.error((String)"\u6839\u636e\u6570\u636e\u7ef4\u5ea6\uff08\u9879\u76eeID\u3001\u4f9b\u5e94\u5546ID\u3001\u5408\u540c\u767b\u8bb0ID\u3001\u6536\u6b3e\u5355\u4f4dID\uff09\u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff01");
        }
        if (alreadyDataList.size() > 1) {
            this.logger.error("\u6839\u636e\u6570\u636e\u7ef4\u5ea6\uff08\u9879\u76eeID-{}\u3001\u4f9b\u5e94\u5546ID-{}\u3001\u5408\u540c\u767b\u8bb0ID-{}\u3001\u6536\u6b3e\u65b9ID-{}\uff09\u67e5\u8be2\u7684\u6570\u636e\u6709\u8bef\uff0c\u540c\u4e00\u6570\u636e\u7ef4\u5ea6\u4e0b\u53ea\u80fd\u6709\u4e00\u6761\u6570\u636e\uff0c\u67e5\u8be2\u5230\u7684\u6570\u636e\u5df2\u8d85\u8fc7\u4e00\u6761\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff01\uff0cparamVO-{}\uff0c\u67e5\u8be2\u7ed3\u679c-{}", new Object[]{paramVO.getProjectId(), paramVO.getSupplierId(), paramVO.getContractRegisterId(), paramVO.getPayeeId(), JSONObject.toJSONString((Object)paramVO), alreadyDataList.toString()});
            return CommonResponse.error((String)"\u6839\u636e\u6570\u636e\u7ef4\u5ea6\uff08\u9879\u76eeID\u3001\u4f9b\u5e94\u5546ID\u3001\u5408\u540c\u767b\u8bb0ID\u3001\u6536\u6b3e\u65b9ID\uff09\u67e5\u8be2\u7684\u6570\u636e\u6709\u8bef\uff0c\u540c\u4e00\u6570\u636e\u7ef4\u5ea6\u4e0b\u53ea\u80fd\u6709\u4e00\u6761\u6570\u636e\uff0c\u67e5\u8be2\u5230\u7684\u6570\u636e\u5df2\u8d85\u8fc7\u4e00\u6761\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff01");
        }
        PMPayApplyEntity alreadyData = alreadyDataList.get(0);
        BigDecimal alreadyDataTotalPayableMny = alreadyData.getTotalPayableMny();
        if (alreadyDataTotalPayableMny == null) {
            alreadyDataTotalPayableMny = BigDecimal.ZERO;
            alreadyData.setTotalPayableMny(BigDecimal.ZERO);
        }
        if ((alreadyDataTotalPaidMny = alreadyData.getTotalPaidMny()) == null) {
            alreadyDataTotalPaidMny = BigDecimal.ZERO;
            alreadyData.setTotalPaidMny(BigDecimal.ZERO);
        }
        if ((alreadyDataCanPayMny = alreadyData.getCanPayMny()) == null) {
            alreadyDataCanPayMny = BigDecimal.ZERO;
            alreadyData.setCanPayMny(BigDecimal.ZERO);
        }
        if ((subtract = alreadyDataTotalPayableMny.subtract(alreadyDataTotalPaidMny)).compareTo(alreadyDataCanPayMny) < 0) {
            this.logger.error("\u67e5\u8be2\u5230\u7684\u6570\u636e\u4e2d\uff0c\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u3010" + alreadyDataTotalPayableMny + "\u3011 - \u7d2f\u8ba1\u5df2\u4ed8\u91d1\u989d\u3010" + alreadyDataTotalPaidMny + "\u3011 < \u53ef\u652f\u4ed8\u91d1\u989d\u3010" + alreadyDataCanPayMny + "\u3011\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0cparamVO-{}\uff0c\u67e5\u8be2\u7ed3\u679c-{}", (Object)paramVO.toString(), (Object)alreadyDataList.toString());
            return CommonResponse.error((String)("\u67e5\u8be2\u5230\u7684\u6570\u636e\u4e2d\uff0c\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u3010" + alreadyDataTotalPayableMny + "\u3011 - \u7d2f\u8ba1\u5df2\u4ed8\u91d1\u989d\u3010" + alreadyDataTotalPaidMny + "\u3011 < \u53ef\u652f\u4ed8\u91d1\u989d\u3010" + alreadyDataCanPayMny + "\u3011\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01"));
        }
        if (alreadyData.getCanPayMny().compareTo(BigDecimal.ZERO) <= 0) {
            this.logger.error("\u4ed8\u6b3e\u7ed3\u679c-\u3010{}\u3011\u5904\u7406\u5931\u8d25\uff0c\u5f53\u524d\u6570\u636e[database-{}]\u5269\u4f59\u53ef\u652f\u4ed8\u91d1\u989d\u4e3a0, \u4e0d\u5728\u8fdb\u884c\u6570\u636e\u5904\u7406\u64cd\u4f5c\uff01", (Object)JSONObject.toJSONString((Object)paramVO), (Object)JSONObject.toJSONString((Object)saveEntity));
        }
        this.logger.info("\u5f53\u524d\u7d2f\u8ba1\u5b9e\u4ed8\uff1a{}\uff0c\u672c\u6b21\u589e\u52a0\u5b9e\u4ed8\u91d1\u989d\uff1a{}", (Object)alreadyDataTotalPaidMny, (Object)payMnyActual);
        saveEntity.setTotalPaidMny(payMnyActual.add(alreadyDataTotalPaidMny));
        this.logger.info("\u5f53\u524d\u53ef\u652f\u4ed8\u91d1\u989d\uff1a {}, \u672c\u6b21\u6263\u9664\u53ef\u652f\u4ed8\u91d1\u989d\uff1a{}", (Object)alreadyData.getCanPayMny(), (Object)payMnyActual);
        saveEntity.setCanPayMny(alreadyData.getCanPayMny().subtract(payMnyActual));
        saveEntity.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        this.setDimensions(projectId, supplierId, contractRegisterId, payeeId, saveEntity);
        CommonResponse<PMPayApplyVO> doSaveRes = this.doSave(saveEntity, "update");
        this.logger.info("zzyj-financeintegration---PMPayApplyServiceImpl---writeOff\u65b9\u6cd5--end\uff0c\u7ed3\u679c-{}", (Object)JSONObject.toJSONString(doSaveRes, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return doSaveRes;
    }

    private CommonResponse<PMPayApplyVO> doSave(PMPayApplyEntity saveEntity, String operateFlag) {
        this.logger.info("zzyj-financeintegration---PMPayApplyServiceImpl---doSave\u65b9\u6cd5--begin\uff0csaveEntity-{}\uff0coperateFlag-{}", (Object)saveEntity.toString(), (Object)operateFlag);
        this.logger.info("\u6267\u884c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5f00\u59cb\uff0c\u63a8\u9001\u6570\u636e-{}", (Object)JSONObject.toJSONString((Object)saveEntity));
        if ("add".equals(operateFlag)) {
            this.pmPayApplyMapper.insertData(saveEntity);
        } else {
            this.pmPayApplyMapper.updateData(saveEntity);
        }
        this.logger.info("zzyj-financeintegration---PMPayApplyServiceImpl---doSave\u65b9\u6cd5--end\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u6210\u529f\uff01");
        return CommonResponse.success((String)"\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u6210\u529f");
    }

    private List<PMPayApplyEntity> getByDataDimensions(PMPayApplyVO paramVO) {
        this.logger.info("\u6839\u636e\u6570\u636e\u7ef4\u5ea6\uff08\u9879\u76eeID\u3001\u4f9b\u5e94\u5546ID\u3001\u5408\u540c\u767b\u8bb0ID\u3001\u6536\u6b3e\u65b9ID\uff09\u67e5\u8be2\u662f\u5426\u5df2\u6709\u6570\u636e\uff0c\u540c\u4e00\u6570\u636e\u7ef4\u5ea6\u4e0b\u53ea\u80fd\u6709\u4e00\u6761\u6570\u636e\uff0cparamVO-{}", (Object)paramVO.toString());
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"XMID", (Object)paramVO.getProjectId())).eq((Object)"GYSID", (Object)paramVO.getSupplierId())).eq((Object)"HTDJID", (Object)paramVO.getContractRegisterId())).eq((Object)"SKF", (Object)paramVO.getPayeeId());
        List resList = this.pmPayApplyMapper.selectList((Wrapper)queryWrapper);
        this.logger.info("\u6839\u636e\u6570\u636e\u7ef4\u5ea6\uff08\u9879\u76eeID\u3001\u4f9b\u5e94\u5546ID\u3001\u5408\u540c\u767b\u8bb0ID\u3001\u6536\u6b3e\u65b9ID\uff09\u67e5\u8be2\u662f\u5426\u5df2\u6709\u6570\u636e\uff0c\u540c\u4e00\u6570\u636e\u7ef4\u5ea6\u4e0b\u53ea\u80fd\u6709\u4e00\u6761\u6570\u636e\uff0c\u67e5\u8be2\u7ed3\u679c-{}", (Object)resList.toString());
        return resList;
    }

    private CommonResponse<PMPayApplyVO> isNullDimensions(PMPayApplyVO paramVO) {
        if (StringUtils.isBlank((CharSequence)paramVO.getProjectId())) {
            this.logger.error("\u9879\u76eeID\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0cparamVO-{}", (Object)paramVO.toString());
            return CommonResponse.error((String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01");
        }
        if (StringUtils.isBlank((CharSequence)paramVO.getSupplierId())) {
            this.logger.error("\u4f9b\u5e94\u5546ID\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0cparamVO-{}", (Object)paramVO.toString());
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01");
        }
        if (StringUtils.isBlank((CharSequence)paramVO.getContractRegisterId())) {
            this.logger.error("\u5408\u540c\u767b\u8bb0ID\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0cparamVO-{}", (Object)paramVO.toString());
            return CommonResponse.error((String)"\u5408\u540c\u767b\u8bb0ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01");
        }
        if (StringUtils.isBlank((CharSequence)paramVO.getPayeeId())) {
            this.logger.error("\u6536\u6b3e\u5355\u4f4dID\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0cparamVO-{}", (Object)paramVO.toString());
            return CommonResponse.error((String)"\u6536\u6b3e\u5355\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01");
        }
        return null;
    }

    private CommonResponse<PMPayApplyVO> isRightContractRegisterId(PMPayApplyVO paramVO, Integer isContract, String contractRegisterId) {
        if (isContract == null) {
            this.logger.error("\u662f\u5426\u6709\u5408\u540c\u6807\u8bc6\uff081-\u6709\u5408\u540c\u30010-\u65e0\u5408\u540c\uff09\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0cparamVO-{}", (Object)paramVO.toString());
            return CommonResponse.error((String)"\u662f\u5426\u6709\u5408\u540c\u6807\u8bc6\uff081-\u6709\u5408\u540c\u30010-\u65e0\u5408\u540c\uff09\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff01");
        }
        if (isContract != 0 && isContract != 1) {
            this.logger.error("\u662f\u5426\u6709\u5408\u540c\u6807\u8bc6\uff081-\u6709\u5408\u540c\u30010-\u65e0\u5408\u540c\uff09\u9519\u8bef\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0cparamVO-{}", (Object)paramVO.toString());
            return CommonResponse.error((String)"\u662f\u5426\u6709\u5408\u540c\u6807\u8bc6\uff081-\u6709\u5408\u540c\u30010-\u65e0\u5408\u540c\uff09\u9519\u8bef\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff01");
        }
        if (isContract == 1 && "-1".equals(contractRegisterId) || isContract == 0 && !"-1".equals(contractRegisterId)) {
            this.logger.error("\u662f\u5426\u6709\u5408\u540c\u6807\u8bc6\uff081-\u6709\u5408\u540c\u30010-\u65e0\u5408\u540c\uff09\u9519\u8bef\u6216\u5408\u540c\u767b\u8bb0ID\uff08\u6709\u5408\u540c\u4e3a\u5408\u540c\u767b\u8bb0ID\uff0c\u65e0\u5408\u540c\u4e3a-1\uff09\u9519\u8bef\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0cparamVO-{}", (Object)paramVO.toString());
            return CommonResponse.error((String)"\u662f\u5426\u6709\u5408\u540c\u6807\u8bc6\uff081-\u6709\u5408\u540c\u30010-\u65e0\u5408\u540c\uff09\u9519\u8bef\u6216\u5408\u540c\u767b\u8bb0ID\uff08\u6709\u5408\u540c\u4e3a\u5408\u540c\u767b\u8bb0ID\uff0c\u65e0\u5408\u540c\u4e3a-1\uff09\u9519\u8bef\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01");
        }
        return null;
    }

    private void setDimensions(String projectId, String supplierId, String contractRegisterId, String payeeId, PMPayApplyEntity saveEntity) {
        saveEntity.setProjectId(projectId);
        saveEntity.setSupplierId(supplierId);
        saveEntity.setContractRegisterId(contractRegisterId);
        saveEntity.setPayeeId(payeeId);
    }
}

