package com.ejianc.business.financeintegration.PMPayApply.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.financeintegration.PMPayApply.bean.PMJJFEntity;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMJJFService;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMJJFVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * PM费用间接费
 *
 * @author Ssunyj
 */
@RestController
@RequestMapping("pmjjf")
public class PMJJFController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPMJJFService service;


    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<PMJJFVO>> queryDetail(@RequestParam String projectId,String period) {
        List<PMJJFVO> listRes = new ArrayList<>();
        List<PMJJFEntity> list = service.list(new QueryWrapper<PMJJFEntity>().eq("XMID", projectId).eq("KJQJ", period)
                .and(q -> q.eq("PMYY",0).or().isNull("PMYY")));
        if(CollectionUtils.isNotEmpty(list)){
            listRes = BeanMapper.mapList(list, PMJJFVO.class);
        }
        return CommonResponse.success("查询详情数据成功！",listRes);
    }

}
