package com.ejianc.business.financeintegration.PMPayApply.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMJJFService;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMYHSService;
import com.ejianc.business.financeintegration.PMPayApply.util.RedisUtil;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMJJFVO;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMYHSVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.util.List;

/**
 * PM费用间接费
 *
 * @author sunyj
 */
@RestController
@RequestMapping
public class PMYHSApiController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPMYHSService pmyhsService;

    @Autowired
    private JedisPool jedisPool;
    private final String OPERATE = "PM_YHS_SAVE";

    private long retryInterval = 60000;

    private final int maxRetryTime = 10;

    // 推送上季度的印花税数据
    @PostMapping(value = "/api/PMYHSPush/listInsert")
    CommonResponse<PMYHSVO> listInsert(@RequestBody List<PMYHSVO> vo){
        Jedis jedis = null;
        String key = null;
        int retryTime = 0;
        boolean lock = false;
        if (CollectionUtils.isNotEmpty(vo)) {

            try {
                key = getLockKey(vo.get(0).getId());
                jedis = jedisPool.getResource();
                while (!lock && retryTime <= maxRetryTime) {
                    if (retryTime > 0) {
                        logger.info("键-{}第{}次尝试获取redis锁, 第{}毫秒后开始尝试", key, retryTime, retryTime * retryInterval);
                        Thread.sleep(retryTime * retryInterval);
                    }
                    retryTime++;
                    lock = getLock(key, jedis);
                }
                for (PMYHSVO yhsVO : vo) {
                    CommonResponse<PMYHSVO> pmVO = pmyhsService.yhsInsert(yhsVO);
                    if (pmVO.getCode() != 0){
                        return pmVO;
                    }
                }
                return CommonResponse.success("推送财务中间库成功");
            } catch (Exception e) {
                logger.error("印花税结果处理失败！pmVO-{}", JSONObject.toJSONString(vo.get(0)), e);
                return CommonResponse.error("付款结果处理失败!");
            } finally {
                //释放单据锁
                RedisUtil.unLock(jedis, false, key, OPERATE);
                logger.info("redisKey-{}进行Redis锁释放", key);
            }
        }else {
            return CommonResponse.error("付款数据传输失败!");
        }
    }


    private String getLockKey(String id) {
        logger.info("处理印花税数据-{}前加锁", id);
        // 根据数据维度获取锁，维度：印花税PMid
        String redisKey = "PM::"+id;
        logger.info("对保存操作添加Redis锁，redisKey-{}", redisKey);
        return redisKey;
    }

    private Boolean getLock(String key, Jedis jedis) {
        logger.info("从jedisPool获取jedis对象，jedis对象-{}", jedis);
        try {
            // 在数据维度层面进行加锁
            return RedisTool.tryLock(jedis, key, OPERATE, 600);
        } catch (Exception e) {
            logger.info("根据键-{}获取reids锁异常", key, e);
            return false;
        }
    }

}
