package com.ejianc.business.financeintegration.PMPayApply.controller.api;

import com.ejianc.business.financeintegration.PMPayApply.bean.PMZZCCZDEntity;
import com.ejianc.business.financeintegration.PMPayApply.bean.PMZZCDBDEntity;
import com.ejianc.business.financeintegration.PMPayApply.bean.PMZZCRKDEntity;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMJJFService;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMZZCCZDService;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMZZCDBDService;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMZZCRKDService;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMJJFVO;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMZZCCZDVO;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMZZCDBDVO;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMZZCRKDVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.stream.Collectors;

/**
 * PM周转材入库单
 *
 * @author sunyj
 */
@RestController
@RequestMapping
public class PMZZCRKDApiController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPMZZCRKDService pmzzcrkdService;

    @Autowired
    private IPMZZCDBDService pmzzcdbdService;

    @Autowired
    private IPMZZCCZDService pmzzcczdService;

    // 批量插入
    @PostMapping(value = "/api/PMZzcrkd/saveOrUpdate")
    public CommonResponse<Boolean> saveOrUpdate(@RequestBody List<PMZZCRKDVO> list) {
        return CommonResponse.success(pmzzcrkdService.saveBatch(BeanMapper.mapList(list,PMZZCRKDEntity.class)));
    }

    /**
      * @Description delete 批量删除单据
     * @Param [ids]
            */
    @RequestMapping(value = "/api/PMZzcrkd/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> delete(@RequestBody List<String> list) {
        return CommonResponse.success(pmzzcrkdService.deleteByIds(list));
    }

    // 批量插入 调拨单
    @PostMapping(value = "/api/PMZzcdbd/saveDbd")
    public CommonResponse<Boolean> saveDbd(@RequestBody List<PMZZCDBDVO> list) {
        return CommonResponse.success(pmzzcdbdService.saveBatch(BeanMapper.mapList(list,PMZZCDBDEntity.class)));
    }

    // 批量插入 处置单
    @PostMapping(value = "/api/PMZzcczd/saveCzd")
    public CommonResponse<Boolean> saveCzd(@RequestBody List<PMZZCCZDVO> list) {
        return CommonResponse.success(pmzzcczdService.saveBatch(BeanMapper.mapList(list,PMZZCCZDEntity.class)));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/api/PMZzcczd/deleteCzd", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> deleteCzd(@RequestBody List<String> list) {
        return CommonResponse.success(pmzzcczdService.deleteByIds(list));
    }
}
