package com.ejianc.business.financeintegration.PMPayApply.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.QueryChainWrapper;
import com.ejianc.business.financeintegration.PMPayApply.bean.PMJJFEntity;
import com.ejianc.business.financeintegration.PMPayApply.mapper.PMJJFMapper;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMJJFService;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMJJFVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * PM费用间接费
 *
 * @author sunyj
 */
@Service("PMJJFService")
public class PMJJFServiceImpl extends BaseServiceImpl<PMJJFMapper, PMJJFEntity> implements IPMJJFService {

    @Override
    public boolean updateEntity(String projectId, String period,String cwFlag) {
        LambdaUpdateWrapper<PMJJFEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(PMJJFEntity::getProjectId,projectId);
        updateWrapper.eq(PMJJFEntity::getPeriod,period);
        updateWrapper.set(PMJJFEntity::getCwFlag,cwFlag);
        return super.update(updateWrapper);
    }

    @Override
    public List<PMJJFVO> getDetailByProjectId(Long projectId) {
        List<PMJJFVO> listRes = new ArrayList<>();
        List<PMJJFEntity> list = this.list(new QueryWrapper<PMJJFEntity>().eq("XMID", projectId)
                .and(q -> q.eq("PMYY",0).or().isNull("PMYY")));
         listRes = BeanMapper.mapList(list, PMJJFVO.class);
        return  listRes;
    }
}
