package com.ejianc.business.financeintegration.PMPayApply.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.financeintegration.PMPayApply.bean.PMYHSEntity;
import com.ejianc.business.financeintegration.PMPayApply.mapper.PMYHSMapper;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMYHSService;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMYHSVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 印花税
 *
 * @author generator
 */
@Service("PMYHSService")
public class PMYHSImpl extends BaseServiceImpl<PMYHSMapper, PMYHSEntity> implements IPMYHSService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private PMYHSMapper pmyhsMapper;


    // 工资支付申请生效
    @Override
    public CommonResponse<PMYHSVO> yhsInsert(PMYHSVO pmyhsvo) {
        logger.info("zzyj-financeintegration---PMYHSImpl---yhsInsert--begin，PMYHSVO={}", JSONObject.toJSONString(pmyhsvo));
        SimpleDateFormat  sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        // 校验数据维度是否为空
        CommonResponse<PMYHSVO> checkRes = isNullDimensions(pmyhsvo);
        if (checkRes != null) {
            return checkRes;
        }
        QueryWrapper<PMYHSEntity> queryWrapper = new QueryWrapper<PMYHSEntity>();
        queryWrapper.eq("PMID", pmyhsvo.getPmBillId());
        List<PMYHSEntity> resultList = pmyhsMapper.selectList(queryWrapper);
        PMYHSEntity pmSalaryPayApplyEntity = null;
        if (CollectionUtils.isNotEmpty(resultList)){
            pmSalaryPayApplyEntity = resultList.get(0);
        }

        if (null != pmSalaryPayApplyEntity){
            logger.info("根据数据维度-印花税单据id,查询中间库已有数据，请勿重复提交，查询结果-{}", pmSalaryPayApplyEntity.toString());
            return CommonResponse.error("根据数据维度-印花税单据id,查询中间库已有数据，请勿重复提交！");
        }

        pmyhsvo.setCreateTime(sdf.format(new Date()));
        PMYHSEntity saveEntity = BeanMapper.map(pmyhsvo, PMYHSEntity.class);
        super.saveOrUpdate(saveEntity);

        logger.info("zzyj-financeintegration---PMYHSEntity--yhsInsert方法--end，推送财务中间库成功！");
        return CommonResponse.success("推送财务中间库成功");
    }

    // 校验数据
    private CommonResponse<PMYHSVO> isNullDimensions(PMYHSVO pmyhsvo) {
        if (StringUtils.isBlank(pmyhsvo.getPmBillId())
                && StringUtils.isBlank(pmyhsvo.getYearmonth())
                && pmyhsvo.getTotalContractMoney() != null
        ){
            logger.error("印花税单id、年月、印花税金额不能为空，推送财务中间库失败，PMYHSVO-{}", pmyhsvo.toString());
            return CommonResponse.error("印花税单id、年月、印花税金额不能为空，推送财务中间库失败，请检查数据！");
        }
        if (StringUtils.isBlank(pmyhsvo.getOperationUnitName()) 
                && StringUtils.isBlank(pmyhsvo.getOrgName())
                && StringUtils.isBlank(pmyhsvo.getCwProjectCode())
                && StringUtils.isBlank(pmyhsvo.getCwProjectName())
                && StringUtils.isBlank(pmyhsvo.getCwAccountCode())
        ){
            logger.error("组织、账套信息不能为空，推送财务中间库失败，PMYHSVO-{}", pmyhsvo.toString());
            return CommonResponse.error("组织、账套信息不能为空，推送财务中间库失败，请检查数据！");
        }
        return null;
    }
}
