/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.financeintegration.PMPayApply.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMYHSService;
import com.ejianc.business.financeintegration.PMPayApply.util.RedisUtil;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMYHSVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@RestController
@RequestMapping
public class PMYHSApiController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPMYHSService pmyhsService;
    @Autowired
    private JedisPool jedisPool;
    private final String OPERATE = "PM_YHS_SAVE";
    private long retryInterval = 60000L;
    private final int maxRetryTime = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"/api/PMYHSPush/listInsert"})
    CommonResponse<PMYHSVO> listInsert(@RequestBody List<PMYHSVO> vo) {
        CommonResponse<PMYHSVO> commonResponse;
        String key;
        Jedis jedis;
        block8: {
            CommonResponse commonResponse2;
            jedis = null;
            key = null;
            boolean lock = false;
            if (!CollectionUtils.isNotEmpty(vo)) return CommonResponse.error((String)"\u4ed8\u6b3e\u6570\u636e\u4f20\u8f93\u5931\u8d25!");
            try {
                key = this.getLockKey(vo.get(0).getId());
                jedis = this.jedisPool.getResource();
                for (int retryTime = 0; !lock && retryTime <= 10; ++retryTime) {
                    if (retryTime > 0) {
                        this.logger.info("\u952e-{}\u7b2c{}\u6b21\u5c1d\u8bd5\u83b7\u53d6redis\u9501, \u7b2c{}\u6beb\u79d2\u540e\u5f00\u59cb\u5c1d\u8bd5", new Object[]{key, retryTime, (long)retryTime * this.retryInterval});
                        Thread.sleep((long)retryTime * this.retryInterval);
                    }
                    lock = this.getLock(key, jedis);
                }
                for (PMYHSVO yhsVO : vo) {
                    CommonResponse<PMYHSVO> pmVO = this.pmyhsService.yhsInsert(yhsVO);
                    if (pmVO.getCode() == 0) continue;
                    commonResponse = pmVO;
                    break block8;
                }
                commonResponse2 = CommonResponse.success((String)"\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u6210\u529f");
            }
            catch (Exception e) {
                CommonResponse commonResponse3;
                try {
                    this.logger.error("\u5370\u82b1\u7a0e\u7ed3\u679c\u5904\u7406\u5931\u8d25\uff01pmVO-{}", (Object)JSONObject.toJSONString((Object)vo.get(0)), (Object)e);
                    commonResponse3 = CommonResponse.error((String)"\u4ed8\u6b3e\u7ed3\u679c\u5904\u7406\u5931\u8d25!");
                }
                catch (Throwable throwable) {
                    RedisUtil.unLock(jedis, false, key, "PM_YHS_SAVE");
                    this.logger.info("redisKey-{}\u8fdb\u884cRedis\u9501\u91ca\u653e", (Object)key);
                    throw throwable;
                }
                RedisUtil.unLock(jedis, false, key, "PM_YHS_SAVE");
                this.logger.info("redisKey-{}\u8fdb\u884cRedis\u9501\u91ca\u653e", (Object)key);
                return commonResponse3;
            }
            RedisUtil.unLock(jedis, false, key, "PM_YHS_SAVE");
            this.logger.info("redisKey-{}\u8fdb\u884cRedis\u9501\u91ca\u653e", (Object)key);
            return commonResponse2;
        }
        RedisUtil.unLock(jedis, false, key, "PM_YHS_SAVE");
        this.logger.info("redisKey-{}\u8fdb\u884cRedis\u9501\u91ca\u653e", (Object)key);
        return commonResponse;
    }

    private String getLockKey(String id) {
        this.logger.info("\u5904\u7406\u5370\u82b1\u7a0e\u6570\u636e-{}\u524d\u52a0\u9501", (Object)id);
        String redisKey = "PM::" + id;
        this.logger.info("\u5bf9\u4fdd\u5b58\u64cd\u4f5c\u6dfb\u52a0Redis\u9501\uff0credisKey-{}", (Object)redisKey);
        return redisKey;
    }

    private Boolean getLock(String key, Jedis jedis) {
        this.logger.info("\u4ecejedisPool\u83b7\u53d6jedis\u5bf9\u8c61\uff0cjedis\u5bf9\u8c61-{}", (Object)jedis);
        try {
            return RedisTool.tryLock((Jedis)jedis, (String)key, (String)"PM_YHS_SAVE", (int)600);
        }
        catch (Exception e) {
            this.logger.info("\u6839\u636e\u952e-{}\u83b7\u53d6reids\u9501\u5f02\u5e38", (Object)key, (Object)e);
            return false;
        }
    }
}

