package com.ejianc.business.financeintegration.ZzyjTradePayApply.bean;

import com.baomidou.mybatisplus.annotation.*;

import java.math.BigDecimal;

@TableName("ZzyjTradeFKSQSJ")
public class ZzyjTradePayApplyEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(
            type = IdType.NONE,
            value = "ID"
    )
    private String id;

    /**
     * 创建时间
     */
    @TableField(
            value = "CJSJ",
            fill = FieldFill.INSERT
    )
    private String createTime;

    /**
     * 修改时间
     */
    @TableField(
            value = "XGSJ",
            fill = FieldFill.INSERT
    )
    private String updateTime;

    /**
     * 项目ID
     */
    @TableField(value = "XMID")
    private String projectId;

    /**
     * 供应商ID
     */
    @TableField(value = "GYSID")
    private String supplierId;

    /**
     * 合同登记ID
     */
    @TableField(value = "HTDJID")
    private String contractRegisterId;

    /**
     * 收款方ID
     */
    @TableField(value = "SKF")
    private String payeeId;

    /**
     * 累计应付金额
     */
    @TableField(value = "LJYFJE")
    private BigDecimal totalPayableMny;

    /**
     * 累计已支付金额
     */
    @TableField(value = "LJYZFJE")
    private BigDecimal totalPaidMny;

    /**
     * 可支付金额
     */
    @TableField(value = "KZFJE")
    private BigDecimal canPayMny;

    /**
     * 支付占用金额
     */
    @TableField(value = "ZFZJE")
    private BigDecimal payingMny;


    /**
     * 标识
     */
    @TableField(value = "BS")
    private String bs;

    public ZzyjTradePayApplyEntity() {
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(String supplierId) {
        this.supplierId = supplierId;
    }

    public String getContractRegisterId() {
        return contractRegisterId;
    }

    public void setContractRegisterId(String contractRegisterId) {
        this.contractRegisterId = contractRegisterId;
    }

    public String getPayeeId() {
        return payeeId;
    }

    public void setPayeeId(String payeeId) {
        this.payeeId = payeeId;
    }

    public BigDecimal getTotalPayableMny() {
        return totalPayableMny;
    }

    public void setTotalPayableMny(BigDecimal totalPayableMny) {
        this.totalPayableMny = totalPayableMny;
    }

    public BigDecimal getTotalPaidMny() {
        return totalPaidMny;
    }

    public void setTotalPaidMny(BigDecimal totalPaidMny) {
        this.totalPaidMny = totalPaidMny;
    }

    public BigDecimal getCanPayMny() {
        return canPayMny;
    }

    public void setCanPayMny(BigDecimal canPayMny) {
        this.canPayMny = canPayMny;
    }

    public BigDecimal getPayingMny() {
        return payingMny;
    }

    public void setPayingMny(BigDecimal payingMny) {
        this.payingMny = payingMny;
    }

    public String getBs() {
        return bs;
    }

    public void setBs(String bs) {
        this.bs = bs;
    }


    @Override
    public String toString() {
        return "ZzyjTradePayApplyEntity{" +
                "id='" + id + '\'' +
                ", createTime='" + createTime + '\'' +
                ", updateTime='" + updateTime + '\'' +
                ", projectId='" + projectId + '\'' +
                ", supplierId='" + supplierId + '\'' +
                ", contractRegisterId='" + contractRegisterId + '\'' +
                ", payeeId='" + payeeId + '\'' +
                ", totalPayableMny=" + totalPayableMny +
                ", totalPaidMny=" + totalPaidMny +
                ", canPayMny=" + canPayMny +
                ", payingMny=" + payingMny +
                ", bs='" + bs + '\'' +
                '}';
    }
}
