package com.ejianc.business.laborservice.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 劳务公司收入合同
 * 
 * @author generator
 * 
 */
public class LaborserviceIncomeContractVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private String contractBillCode; // 单据编号
    private Date contractBillDate; // 单据日期
    private String contractBillCreatorCode; //制单人账号
    private String contractBillCreator; // 制单人
    private String contractStatus; // 合同状态(正常、终止、作废)
    private String backStatus; // 返还情况(未返还、已返还)
    private Long contractId; // 合同id
    private String contractCode; // 合同编号
    private String contractName; // 合同名称
    private String innerContractId; // 内部合同号
    private Long firstPartyId; // 甲方id
    private String firstPartyName; // 甲方
    private Long projectManagerDeptId; // 项目管理部id
    private String projectManagerDept; // 项目管理部
    private Long supplierId; // 乙方id
    private String supplier; // 乙方
    private Long supplierSignerId;//乙方签订人id
    private String supplierSignerName; // 乙方签订人
    private String supplierSignerCertId; // 乙方签订人身份证编号
    private Long supplierPhone; // 乙方签订人电话
    private Long projectId; // 项目id
    private String projectCode; // 项目code
    private String projectName; // 项目名称
    private String projectAddress; // 项目地址
    private Long invoiceTypeId; // 发票类型id
    private String invoiceTypeName; // 发票类型(专票、普票)
    private BigDecimal taxRate; // 税率%
    private BigDecimal contractTaxMny; // 合同暂订含税金额
    private BigDecimal contractAccumulateTaxMny; // 合同累计含税金额
    private BigDecimal contractAccumulateMny; // 合同累计不含税金额
    private BigDecimal contractAccumulateTax; // 合同累计税额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签订日期
    private String notes; // 备忘
    private BigDecimal earlyAccmulateInvoeAmount; // 期初累计开票金额
    private BigDecimal earlyAccmulateCollectionAmount; // 期初累计收款金额
    private String hasStationLaborManager; // 是否含派驻劳资员
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractBillCode() {
        return contractBillCode;
    }

    public void setContractBillCode(String contractBillCode) {
        this.contractBillCode = contractBillCode;
    }
    public Date getContractBillDate() {
        return contractBillDate;
    }

    public void setContractBillDate(Date contractBillDate) {
        this.contractBillDate = contractBillDate;
    }

    public String getContractBillCreatorCode() {
        return contractBillCreatorCode;
    }

    public void setContractBillCreatorCode(String contractBillCreatorCode) {
        this.contractBillCreatorCode = contractBillCreatorCode;
    }

    public String getContractBillCreator() {
        return contractBillCreator;
    }

    public void setContractBillCreator(String contractBillCreator) {
        this.contractBillCreator = contractBillCreator;
    }
    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }
    public String getBackStatus() {
        return backStatus;
    }

    public void setBackStatus(String backStatus) {
        this.backStatus = backStatus;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getInnerContractId() {
        return innerContractId;
    }

    public void setInnerContractId(String innerContractId) {
        this.innerContractId = innerContractId;
    }
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getFirstPartyId() {
        return firstPartyId;
    }
    @ReferDeserialTransfer
    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }
    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getProjectManagerDeptId() {
        return projectManagerDeptId;
    }
    @ReferDeserialTransfer
    public void setProjectManagerDeptId(Long projectManagerDeptId) {
        this.projectManagerDeptId = projectManagerDeptId;
    }
    public String getProjectManagerDept() {
        return projectManagerDept;
    }

    public void setProjectManagerDept(String projectManagerDept) {
        this.projectManagerDept = projectManagerDept;
    }
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplier() {
        return supplier;
    }

    @ReferSerialTransfer(referCode = "laborservice_team_ref")
    public Long getSupplierSignerId() {
        return supplierSignerId;
    }
    @ReferDeserialTransfer
    public void setSupplierSignerId(Long supplierSignerId) {
        this.supplierSignerId = supplierSignerId;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }

    public String getSupplierSignerName() {
        return supplierSignerName;
    }

    public void setSupplierSignerName(String supplierSignerName) {
        this.supplierSignerName = supplierSignerName;
    }

    public String getSupplierSignerCertId() {
        return supplierSignerCertId;
    }

    public void setSupplierSignerCertId(String supplierSignerCertId) {
        this.supplierSignerCertId = supplierSignerCertId;
    }
    public Long getSupplierPhone() {
        return supplierPhone;
    }

    public void setSupplierPhone(Long supplierPhone) {
        this.supplierPhone = supplierPhone;
    }
    @ReferSerialTransfer(referCode = "labor_project_ref")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
    public Long getInvoiceTypeId() {
        return invoiceTypeId;
    }

    public void setInvoiceTypeId(Long invoiceTypeId) {
        this.invoiceTypeId = invoiceTypeId;
    }
    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractAccumulateTaxMny() {
        return contractAccumulateTaxMny;
    }

    public void setContractAccumulateTaxMny(BigDecimal contractAccumulateTaxMny) {
        this.contractAccumulateTaxMny = contractAccumulateTaxMny;
    }
    public BigDecimal getContractAccumulateMny() {
        return contractAccumulateMny;
    }

    public void setContractAccumulateMny(BigDecimal contractAccumulateMny) {
        this.contractAccumulateMny = contractAccumulateMny;
    }
    public BigDecimal getContractAccumulateTax() {
        return contractAccumulateTax;
    }

    public void setContractAccumulateTax(BigDecimal contractAccumulateTax) {
        this.contractAccumulateTax = contractAccumulateTax;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public String getNotes() {
        return notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }
    public BigDecimal getEarlyAccmulateInvoeAmount() {
        return earlyAccmulateInvoeAmount;
    }

    public void setEarlyAccmulateInvoeAmount(BigDecimal earlyAccmulateInvoeAmount) {
        this.earlyAccmulateInvoeAmount = earlyAccmulateInvoeAmount;
    }
    public BigDecimal getEarlyAccmulateCollectionAmount() {
        return earlyAccmulateCollectionAmount;
    }

    public void setEarlyAccmulateCollectionAmount(BigDecimal earlyAccmulateCollectionAmount) {
        this.earlyAccmulateCollectionAmount = earlyAccmulateCollectionAmount;
    }
    public String getHasStationLaborManager() {
        return hasStationLaborManager;
    }

    public void setHasStationLaborManager(String hasStationLaborManager) {
        this.hasStationLaborManager = hasStationLaborManager;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    
}
