package com.ejianc.business.laborservice.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 劳务公司合同变更
 * 
 * @author generator
 * 
 */
public class LaborserviceIncomeContractChangeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private String contractStatus; // 合同状态(正常、终止、作废)
    private String backStatus; // 返还情况(未返还、已返还)
    private Long contractId; // 合同id
    private String contractCode; // 合同编号
    private String contractName; // 合同名称
    private String innerContractId; // 内部合同号
    private Long firstPartyId; // 甲方id
    private String firstPartyName; // 甲方
    private Long projectManagerDeptId; // 项目管理部id
    private String projectManagerDept; // 项目管理部
    private Long supplierId; // 乙方id
    private String supplier; // 乙方
    private String supplierSignerName; // 乙方签订人
    private String supplierSignerCertId; // 乙方签订人身份证编号
    private Long supplierPhone; // 乙方签订人电话
    private Long projectId; // 项目id
    private String projectCode; // 项目code
    private String projectName; // 项目名称
    private String projectAddress; // 项目地址
    private Long invoiceTypeId; // 发票类型id
    private String invoiceTypeName; // 发票类型(专票、普票)
    private BigDecimal taxRate; // 税率%
    private BigDecimal contractTaxMny; // 合同暂订含税金额
    private BigDecimal contractAccumulateTaxMny; // 合同累计含税金额(原合同金额-含税)
    private BigDecimal contractAccumulateMny; // 合同累计不含税金额(原合同金额-不含税)
    private BigDecimal contractAccumulateTax; // 合同累计税额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签订日期
    private String notes; // 备忘
    private String hasStationLaborManager; // 是否含派驻劳资员
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private Long operatorId; // 经办人ID
    private String remark; // 备注
    private Long supplierSignerId; // 乙方签订人id
    private String businessStatus; // 业务执行状态
    private String contractType; // 合同类型
    private String storagePlace; // 存放处
    private BigDecimal accumulateInvoicedAmount; // 已累开发票金额
    private BigDecimal accumulateReceivingAmount; // 已累计收款金额
    private BigDecimal beforeChangeTaxMny; // 变更前合同金额(含税)
    private BigDecimal beforeChangeMny; // 变更前合同金额(不含税)
    private String changeReason; // 变更原因
    private Long beforeChangeId; // 原合同id
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate; // 变更时间
    private String invoiceInfo; //发票备注信息
    private String areaId; // 地区
    private String areaName; // 地区名称
    private BigDecimal thisChangeTaxMny; // 本次变更金额
    private String incomeContractCode; // 收入合同编号


    public String getIncomeContractCode() {
        return incomeContractCode;
    }

    public void setIncomeContractCode(String incomeContractCode) {
        this.incomeContractCode = incomeContractCode;
    }

    public BigDecimal getThisChangeTaxMny() {
        return thisChangeTaxMny;
    }

    public void setThisChangeTaxMny(BigDecimal thisChangeTaxMny) {
        this.thisChangeTaxMny = thisChangeTaxMny;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }
    public String getBackStatus() {
        return backStatus;
    }

    public void setBackStatus(String backStatus) {
        this.backStatus = backStatus;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getInnerContractId() {
        return innerContractId;
    }

    public void setInnerContractId(String innerContractId) {
        this.innerContractId = innerContractId;
    }
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getFirstPartyId() {
        return firstPartyId;
    }
    @ReferDeserialTransfer
    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }
    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getProjectManagerDeptId() {
        return projectManagerDeptId;
    }
    @ReferDeserialTransfer
    public void setProjectManagerDeptId(Long projectManagerDeptId) {
        this.projectManagerDeptId = projectManagerDeptId;
    }
    public String getProjectManagerDept() {
        return projectManagerDept;
    }

    public void setProjectManagerDept(String projectManagerDept) {
        this.projectManagerDept = projectManagerDept;
    }
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplier() {
        return supplier;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }
    public String getSupplierSignerName() {
        return supplierSignerName;
    }

    public void setSupplierSignerName(String supplierSignerName) {
        this.supplierSignerName = supplierSignerName;
    }
    public String getSupplierSignerCertId() {
        return supplierSignerCertId;
    }

    public void setSupplierSignerCertId(String supplierSignerCertId) {
        this.supplierSignerCertId = supplierSignerCertId;
    }
    public Long getSupplierPhone() {
        return supplierPhone;
    }

    public void setSupplierPhone(Long supplierPhone) {
        this.supplierPhone = supplierPhone;
    }
    @ReferSerialTransfer(referCode = "labor_project_ref")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
    public Long getInvoiceTypeId() {
        return invoiceTypeId;
    }

    public void setInvoiceTypeId(Long invoiceTypeId) {
        this.invoiceTypeId = invoiceTypeId;
    }
    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractAccumulateTaxMny() {
        return contractAccumulateTaxMny;
    }

    public void setContractAccumulateTaxMny(BigDecimal contractAccumulateTaxMny) {
        this.contractAccumulateTaxMny = contractAccumulateTaxMny;
    }
    public BigDecimal getContractAccumulateMny() {
        return contractAccumulateMny;
    }

    public void setContractAccumulateMny(BigDecimal contractAccumulateMny) {
        this.contractAccumulateMny = contractAccumulateMny;
    }
    public BigDecimal getContractAccumulateTax() {
        return contractAccumulateTax;
    }

    public void setContractAccumulateTax(BigDecimal contractAccumulateTax) {
        this.contractAccumulateTax = contractAccumulateTax;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public String getNotes() {
        return notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }
    public String getHasStationLaborManager() {
        return hasStationLaborManager;
    }

    public void setHasStationLaborManager(String hasStationLaborManager) {
        this.hasStationLaborManager = hasStationLaborManager;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    @ReferSerialTransfer(referCode = "laborservice_team_ref")
    public Long getSupplierSignerId() {
        return supplierSignerId;
    }
    @ReferDeserialTransfer
    public void setSupplierSignerId(Long supplierSignerId) {
        this.supplierSignerId = supplierSignerId;
    }
    public String getBusinessStatus() {
        return businessStatus;
    }

    public void setBusinessStatus(String businessStatus) {
        this.businessStatus = businessStatus;
    }
    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }
    public String getStoragePlace() {
        return storagePlace;
    }

    public void setStoragePlace(String storagePlace) {
        this.storagePlace = storagePlace;
    }
    public BigDecimal getAccumulateInvoicedAmount() {
        return accumulateInvoicedAmount;
    }

    public void setAccumulateInvoicedAmount(BigDecimal accumulateInvoicedAmount) {
        this.accumulateInvoicedAmount = accumulateInvoicedAmount;
    }
    public BigDecimal getAccumulateReceivingAmount() {
        return accumulateReceivingAmount;
    }

    public void setAccumulateReceivingAmount(BigDecimal accumulateReceivingAmount) {
        this.accumulateReceivingAmount = accumulateReceivingAmount;
    }
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    @ReferSerialTransfer(referCode = "labor_income_contract_ref")
    public Long getBeforeChangeId() {
        return beforeChangeId;
    }
    @ReferDeserialTransfer
    public void setBeforeChangeId(Long beforeChangeId) {
        this.beforeChangeId = beforeChangeId;
    }
    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public String getInvoiceInfo() {
        return invoiceInfo;
    }

    public void setInvoiceInfo(String invoiceInfo) {
        this.invoiceInfo = invoiceInfo;
    }

    public String getAreaId() {
        return areaId;
    }

    public void setAreaId(String areaId) {
        this.areaId = areaId;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }
}
