package com.ejianc.business.bid.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 劳务公司-投标项目跟踪
 * 
 * @author generator
 * 
 */
public class BidFollowVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private String projectId; // 项目
    private String projectName; // 项目名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date followDate; // 跟踪日期
    private Long followPerson; // 单位负责人
    private String followPersonName; // 负责人名称
    private String followPersonPhone; // 负责人电话
    private Long innerPerson; // 内部业务员
    private String innerPersonName; // 内部业务员名称
    private Long firstParty; // 甲方
    private String firstPartyName; // 甲方名称
    private String firstPartyType; // 甲方单位性质
    private String bidFollowType; // 跟踪状态
    private String bidState; // 报名状态
    private String followRemark; // 跟踪进展
    private Long bidId; // 招标id
    private String biddingOrgName; // 招标单位名称
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getFollowDate() {
        return followDate;
    }

    public void setFollowDate(Date followDate) {
        this.followDate = followDate;
    }
    public Long getFollowPerson() {
        return followPerson;
    }

    public void setFollowPerson(Long followPerson) {
        this.followPerson = followPerson;
    }
    public String getFollowPersonName() {
        return followPersonName;
    }

    public void setFollowPersonName(String followPersonName) {
        this.followPersonName = followPersonName;
    }
    public String getFollowPersonPhone() {
        return followPersonPhone;
    }

    public void setFollowPersonPhone(String followPersonPhone) {
        this.followPersonPhone = followPersonPhone;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getInnerPerson() {
        return innerPerson;
    }
    @ReferDeserialTransfer
    public void setInnerPerson(Long innerPerson) {
        this.innerPerson = innerPerson;
    }
    public String getInnerPersonName() {
        return innerPersonName;
    }

    public void setInnerPersonName(String innerPersonName) {
        this.innerPersonName = innerPersonName;
    }
    public Long getFirstParty() {
        return firstParty;
    }

    public void setFirstParty(Long firstParty) {
        this.firstParty = firstParty;
    }
    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }
    public String getFirstPartyType() {
        return firstPartyType;
    }

    public void setFirstPartyType(String firstPartyType) {
        this.firstPartyType = firstPartyType;
    }
    public String getBidFollowType() {
        return bidFollowType;
    }

    public void setBidFollowType(String bidFollowType) {
        this.bidFollowType = bidFollowType;
    }
    public String getBidState() {
        return bidState;
    }

    public void setBidState(String bidState) {
        this.bidState = bidState;
    }
    public String getFollowRemark() {
        return followRemark;
    }

    public void setFollowRemark(String followRemark) {
        this.followRemark = followRemark;
    }
    @ReferSerialTransfer(referCode="labor-bid-enroll")
    public Long getBidId() {
        return bidId;
    }
    @ReferDeserialTransfer
    public void setBidId(Long bidId) {
        this.bidId = bidId;
    }
    public String getBiddingOrgName() {
        return biddingOrgName;
    }

    public void setBiddingOrgName(String biddingOrgName) {
        this.biddingOrgName = biddingOrgName;
    }
    
}
