package com.ejianc.business.laborlaw.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 劳务公司-诉讼审理信息登记
 * 
 * @author generator
 * 
 */
public class InfoRegisterVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private String caseCode; // 案号
    private Long caseId; // 诉讼案件
    private String hearCount; // 审理阶段
    private String firstTypeName; // 审理程序名称
    private String firstJudgeName; // 法官名称
    private String firstJudgeCode; // 法官联系方式
    private String firstCourtName; // 法院名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date firstStartDate; // 开庭日期
    private String firstCode; // 审理案号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date firstEndDate; // 执行时间
    private String firstResultName; // 判决结果
    private BigDecimal firstEndAmount; // 执行金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date firstAppealDate; // 上诉截至日期
    private String firstResultRemark; // 判决执行情况
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date firstLastDate; // 再审截至日期
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getCaseCode() {
        return caseCode;
    }

    public void setCaseCode(String caseCode) {
        this.caseCode = caseCode;
    }
    @ReferSerialTransfer(referCode="labor-case-register")
    public Long getCaseId() {
        return caseId;
    }
    @ReferDeserialTransfer
    public void setCaseId(Long caseId) {
        this.caseId = caseId;
    }

    public String getHearCount() {
        return hearCount;
    }

    public void setHearCount(String hearCount) {
        this.hearCount = hearCount;
    }
    public String getFirstTypeName() {
        return firstTypeName;
    }

    public void setFirstTypeName(String firstTypeName) {
        this.firstTypeName = firstTypeName;
    }
    public String getFirstJudgeName() {
        return firstJudgeName;
    }

    public void setFirstJudgeName(String firstJudgeName) {
        this.firstJudgeName = firstJudgeName;
    }
    public String getFirstJudgeCode() {
        return firstJudgeCode;
    }

    public void setFirstJudgeCode(String firstJudgeCode) {
        this.firstJudgeCode = firstJudgeCode;
    }
    public String getFirstCourtName() {
        return firstCourtName;
    }

    public void setFirstCourtName(String firstCourtName) {
        this.firstCourtName = firstCourtName;
    }
    public Date getFirstStartDate() {
        return firstStartDate;
    }

    public void setFirstStartDate(Date firstStartDate) {
        this.firstStartDate = firstStartDate;
    }
    public String getFirstCode() {
        return firstCode;
    }

    public void setFirstCode(String firstCode) {
        this.firstCode = firstCode;
    }
    public Date getFirstEndDate() {
        return firstEndDate;
    }

    public void setFirstEndDate(Date firstEndDate) {
        this.firstEndDate = firstEndDate;
    }
    public String getFirstResultName() {
        return firstResultName;
    }

    public void setFirstResultName(String firstResultName) {
        this.firstResultName = firstResultName;
    }
    public BigDecimal getFirstEndAmount() {
        return firstEndAmount;
    }

    public void setFirstEndAmount(BigDecimal firstEndAmount) {
        this.firstEndAmount = firstEndAmount;
    }
    public Date getFirstAppealDate() {
        return firstAppealDate;
    }

    public void setFirstAppealDate(Date firstAppealDate) {
        this.firstAppealDate = firstAppealDate;
    }
    public String getFirstResultRemark() {
        return firstResultRemark;
    }

    public void setFirstResultRemark(String firstResultRemark) {
        this.firstResultRemark = firstResultRemark;
    }
    public Date getFirstLastDate() {
        return firstLastDate;
    }

    public void setFirstLastDate(Date firstLastDate) {
        this.firstLastDate = firstLastDate;
    }
    
}
