package com.ejianc.business.itax.controller;

import java.io.Serializable;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.itax.utils.DetailIndexExcelReaderZzyj;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.itax.bean.WorkerEntity;
import com.ejianc.business.itax.service.IWorkerService;
import com.ejianc.business.itax.vo.WorkerVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 个税-工人信息
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("worker")
public class WorkerController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IWorkerService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WorkerVO> saveOrUpdate(@RequestBody WorkerVO saveOrUpdateVO) {
    	WorkerEntity entity = BeanMapper.map(saveOrUpdateVO, WorkerEntity.class);
        UserContext userContextCache=sessionManager.getUserContext();
        if(entity.getId()==null||entity.getId()==0){
            //设置创建人姓名  
            entity.setCreateUserName(userContextCache.getUserName());
        }else{
            //设置修改人姓名  
            entity.setUpdateUserName(userContextCache.getUserName());
        }

        entity.setBillCode(entity.getIdNum());//单据编号就是身份证号

    	service.saveOrUpdate(entity, false);
    	WorkerVO vo = BeanMapper.map(entity, WorkerVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WorkerVO> queryDetail(Long id) {
    	WorkerEntity entity = service.selectById(id);
    	WorkerVO vo = BeanMapper.map(entity, WorkerVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkerVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (WorkerVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(WorkerVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WorkerVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("idNum");
        fuzzyFields.add("phone");


        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("state",new Parameter(QueryParam.EQ,1));//在职状态

        IPage<WorkerEntity> page = service.queryPage(param,false);
        IPage<WorkerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WorkerVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<WorkerEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Worker-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refWorkerData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WorkerVO>> refWorkerData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<WorkerEntity> page = service.queryPage(param,false);
        IPage<WorkerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WorkerVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }



    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportInfo(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<WorkerVO> successList = new ArrayList<>();
        List<WorkerVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        else {
            List<List<String>> result = DetailIndexExcelReaderZzyj.readExcel(mf);
            if (result != null && result.size() > 0) {
                //给每行赋值
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    WorkerVO detailVO = new WorkerVO();
                    detailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                    //姓名
                    try {
                        String name = datas.get(1).trim();
                        if(StringUtils.isNotBlank(name)) {
                            detailVO.setName(name);
                        }else {
                            throw new Exception("姓名不能为空！");
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMsg("姓名错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    int type = 0;//本条数据类型 0异常数据 1新增 2删除
                    //人员状态
                    try {
                        String state = datas.get(7);
                        if(StringUtils.isNotBlank(state)) {
                            if("正常".equals(state)){
                                type = 1;
                            }else if ("非正常".equals(state)){
                                type =2;
                            }else {
                                throw new Exception("人员状态填写错误！");
                            }
                            detailVO.setType(type);
                        }else {
                            throw new Exception("人员状态不能为空！");
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMsg("人员状态不能为空！");
                        errorList.add(detailVO);
                        continue;
                    }

                    //身份证号
                    try {
                        String idNum = datas.get(3);
                        if(StringUtils.isNotBlank(idNum)) {
                            detailVO.setIdNum(idNum);
                        }else {
                            throw new Exception("身份证号输入错误！");
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMsg("身份证号错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    //性别
                    try {
                        String sex = datas.get(5);
                        if(StringUtils.isNotBlank(sex)) {
                            detailVO.setSex(sex);
                        }else {
                            throw new Exception("性别不能为空！");
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMsg("性别不能为空！");
                        errorList.add(detailVO);
                        continue;
                    }
                    //手机号
                    try {
                        String phone = datas.get(10);
                        if(StringUtils.isNotBlank(phone)) {
                            detailVO.setPhone(phone);
                        }else {
                            throw new Exception("手机号不能为空！");
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMsg("手机号不能为空！");
                        errorList.add(detailVO);
                        continue;
                    }
                    //工作开始日期
                    try {
                        String date = datas.get(11);
                        if(StringUtils.isNotBlank(date)) {

                            long timestamp = (long) ((new Double(date) - 25569) * 86400 * 1000);

                            //Date dateTime = DateUtil.parseDate(date);
                            detailVO.setEffectiveStartTime(new Date(timestamp));
                        }else {
                            throw new Exception("工作开始日期不能为空！");
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMsg("工作开始日期解析失败！");
                        errorList.add(detailVO);
                        continue;
                    }
                    detailVO.setRowState("add");
                    successList.add(detailVO);
                }

                //List<WorkerVO> successReturnList = new ArrayList<>();
                List<WorkerEntity> successEntityAddList = new ArrayList<>();
                //List<WorkerEntity> successEntityDeleteList = new ArrayList<>();
                if (successList.size() > 0) {
                    List<String> idCardList = successList.stream().map(WorkerVO::getIdNum).collect(Collectors.toList());
                    logger.info("人员身份证号map: {}", JSONObject.toJSONString(idCardList));
                    //获取工人数据
                    Map<String, WorkerEntity> map = new HashMap<>();
                    LambdaQueryWrapper<WorkerEntity> lambdaQueryWrapper1 = new LambdaQueryWrapper<>();
                    lambdaQueryWrapper1.eq(WorkerEntity::getState, 1);
                    lambdaQueryWrapper1.in(WorkerEntity::getIdNum, idCardList);
                    lambdaQueryWrapper1.isNotNull(WorkerEntity::getIdNum);
                    List<WorkerEntity> rosterEntityList = service.list(lambdaQueryWrapper1);
                    map = rosterEntityList.stream().collect(Collectors.toMap(p -> p.getIdNum(), Function.identity()));
                    for (WorkerVO workerVO : successList) {
                        if (workerVO.getType() == 1){
                            //新增   新增时现在数据库中不能存在相同身份证号的人员
                            if (map.containsKey(workerVO.getIdNum())){
                                workerVO.setErrorMsg("此人员已在库中！");
                                errorList.add(workerVO);
                            }else {
                                WorkerEntity workerEntity = new WorkerEntity();
                                workerEntity.setName(workerVO.getName());
                                workerEntity.setIdNum(workerVO.getIdNum());
                                workerEntity.setBillCode(workerVO.getIdNum());
                                workerEntity.setPhone(workerVO.getPhone());
                                workerEntity.setEffectiveStartTime(workerVO.getEffectiveStartTime());
                                workerEntity.setSex(workerVO.getSex());
                                workerEntity.setState(1);
                                workerEntity.setBillState(3);
                                workerEntity.setCreateUserName("导入数据");
                                successEntityAddList.add(workerEntity);
                            }
                        }else if (workerVO.getType() == 2){
                            //删除  在库中的人员才能删除
                            if (map.containsKey(workerVO.getIdNum())){
                                WorkerEntity workerEntity = map.get(workerVO.getIdNum());
                                workerEntity.setState(2);//离职
                                workerEntity.setEffectiveEndTime(DateUtil.date());//结束时间
                                successEntityAddList.add(workerEntity);
                            }else {
                                workerVO.setErrorMsg("此人员未在库中！");
                                errorList.add(workerVO);
                            }
                        }
                    }
                    service.saveOrUpdateBatch(successEntityAddList);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());


        return CommonResponse.success(json);
    }

}
