package com.ejianc.business.laborservice.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.laborservice.vo.LaborserviceExpendContractVO;
import com.ejianc.business.laborservice.vo.LaborserviceIncomeContractVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.laborservice.mapper.LaborserviceIncomeContractMapper;
import com.ejianc.business.laborservice.bean.LaborserviceIncomeContractEntity;
import com.ejianc.business.laborservice.service.ILaborserviceIncomeContractService;

import java.util.List;
import java.util.Map;

/**
 * 劳务公司收入合同
 * 
 * @author generator
 * 
 */
@Service("laborserviceIncomeContractService")
public class LaborserviceIncomeContractServiceImpl extends BaseServiceImpl<LaborserviceIncomeContractMapper, LaborserviceIncomeContractEntity> implements ILaborserviceIncomeContractService{
    @Override
    public List<LaborserviceIncomeContractVO> getUnionContractInfo(String teamId, Long projectId) {

        return baseMapper.getUnionContractInfo(teamId, projectId);
    }

    @Override
    public LaborserviceIncomeContractVO queryExpendDetail(Long id) {
        LaborserviceIncomeContractEntity entity = baseMapper.selectById(id);
        if (entity!=null) {
            LaborserviceIncomeContractVO incomeContractVO = BeanMapper.map(entity, LaborserviceIncomeContractVO.class);
            List<LaborserviceExpendContractVO> expendList = baseMapper.queryExpendList(id);
            incomeContractVO.setExpendList(expendList);
            return incomeContractVO;
        }else {
            return null;
        }
    }
    @Override
    public List<LaborserviceIncomeContractVO> queryListTree(Map<String,Object> params){
        List<LaborserviceIncomeContractEntity> laborserviceIncomeContractEntities = baseMapper.selectList(null);
        List<LaborserviceIncomeContractVO> contractVOList = BeanMapper.mapList(laborserviceIncomeContractEntities, LaborserviceIncomeContractVO.class);
        return contractVOList;
    }

    public IPage<LaborserviceIncomeContractVO> listContractLedger(QueryParam param){
        IPage<LaborserviceIncomeContractVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<LaborserviceIncomeContractVO> contractVOList = baseMapper.listContractLedger(changeToQueryWrapper(param), page);
        IPage<LaborserviceIncomeContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(contractVOList);
        return pageData;
    }
}
