package com.ejianc.business.itax.mapper;

import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.itax.bean.SalaryDetailEntity;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 工人工资上传明细
 * 
 * @author generator
 * 
 */
@Mapper
public interface SalaryDetailMapper extends BaseCrudMapper<SalaryDetailEntity> {
    @Select("SELECT count(*) num FROM `zzyj_laborservice_itax_salary_detail`\n" +
            "where dr = 0 and id_num = #{idNum} and pid in (\n" +
            "SELECT id FROM `zzyj_laborservice_itax_salary`\n" +
            "where dr = 0 and bill_state in (1,3)\n" +
            "and DATE_FORMAT(bill_time, '%Y%m') = DATE_FORMAT(#{billTime}, '%Y%m' )\n" +
            ")")
    Integer thisMonthWorkerRegistNum(Date billTime,String idNum);


    @Select("SELECT IFNULL(SUM(money),0) num FROM `zzyj_laborservice_itax_salary_detail`\n" +
            "where dr = 0 and id_num = #{idNum} and pid in (\n" +
            "SELECT id FROM `zzyj_laborservice_itax_salary`\n" +
            "where dr = 0 and bill_state in (1,3)\n" +
            "and DATE_FORMAT(bill_time, '%Y%m') = DATE_FORMAT(#{billTime}, '%Y%m' )\n" +
            ")")
    BigDecimal thisMonthWorkerRegistMny(Date billTime, String idNum);

/**
*
 */
//    @Select("SELECT IFNULL(SUM(money),0) mny FROM `zzyj_laborservice_itax_salary_detail`\n" +
//            "where dr = 0 and id_num = #{idNum} and last_month_state = '已申报' and salary_pay_state = '已发放' and pid in (\n" +
//            "SELECT id FROM `zzyj_laborservice_itax_salary`\n" +
//            "where dr = 0 and bill_state in (1,3)\n" +
//            "and DATE_FORMAT(bill_time, '%Y') = DATE_FORMAT( #{billTime}, '%Y' )\n" +
//            ")")
//    BigDecimal thisYearWorkerRegistMny(Date billTime, String idNum);

    @Select("SELECT IFNULL(sum(money)+ this_year_income,0) as money from (\n" +
            "SELECT id,name,(case when last_month_state = '已申报' then money\n" +
            " else 0 end) money,last_month_state,this_year_income FROM `zzyj_laborservice_itax_salary_detail`\n" +
            " where dr = 0 and id_num = #{idNum}\n" +
            "and salary_pay_state = '已发放' \n" +
            "and pid in (\n" +
            "  SELECT id FROM `zzyj_laborservice_itax_salary`\n" +
            "  where dr = 0 and bill_state in (1,3)\n" +
            "  and PERIOD_DIFF( date_format( #{billTime} , '%Y%m' ) , date_format( bill_time, '%Y%m' ) ) =1\n" +
            "  )\n" +
            " ORDER BY update_time desc\n" +
            ")as t\n")
    BigDecimal thisYearWorkerRegistMny(Date billTime, String idNum);


    @Select("SELECT IFNULL(count(*)+1,1)*5000 mny FROM `zzyj_laborservice_itax_salary_detail`\n" +
            "where dr = 0 and id_num = #{idNum} and (last_month_state = '已申报' || last_month_state = '申报0') and salary_pay_state = '已发放' and pid in (\n" +
            "SELECT id FROM `zzyj_laborservice_itax_salary`\n" +
            "where dr = 0 and bill_state in (1,3)\n" +
            "and DATE_FORMAT(bill_time, '%Y') = DATE_FORMAT(#{billTime}, '%Y' )\n" +
            ")")
    BigDecimal thisYearWorkerRegistNum(Date billTime,String idNum);

    @Select("SELECT IFNULL(SUM(money),0) mny FROM `zzyj_laborservice_itax_salary_detail`\n" +
            "where dr = 0 and id_num = #{idNum} and salary_pay_state = '已发放' and (last_month_state = '未申报' || last_month_state = '申报0') and pid in (\n" +
            "SELECT id FROM `zzyj_laborservice_itax_salary`\n" +
            "where dr = 0 and bill_state in (1,3)\n" +
            "and DATE_FORMAT(bill_time, '%Y') = DATE_FORMAT( #{billTime}, '%Y' )\n" +
            ")")
    BigDecimal thisYearWorkerNoRegistMny(Date billTime, String idNum);


    @Select("SELECT IFNULL(SUM(this_month_itax),0) num FROM `zzyj_laborservice_itax_salary_detail`\n" +
            "where dr = 0 and id_num = #{idNum} and pid in (\n" +
            "SELECT id FROM `zzyj_laborservice_itax_salary`\n" +
            "where dr = 0 and bill_state in (1,3)\n" +
            "and DATE_FORMAT(bill_time, '%Y%m') = DATE_FORMAT(#{billTime}, '%Y%m' )\n" +
            ")")
    BigDecimal thisMonthWorkerItaxMny(Date billTime, String idNum);
}
