package com.ejianc.business.itax.service.impl;

import com.ejianc.business.itax.bean.SalaryDetailEntity;
import com.ejianc.business.itax.bean.SalaryEntity;
import com.ejianc.business.itax.mapper.SalaryMapper;
import com.ejianc.business.itax.service.ISalaryDetailService;
import com.ejianc.business.itax.service.ISalaryService;
import org.apache.commons.collections.CollectionUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Service("salary") 
public class SalaryBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private ISalaryService service;

	@Autowired
	private ISalaryDetailService detailService;
	@Autowired
	private SalaryMapper mapper;

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {

		//子表不允许重复
		List<String> stringList = mapper.idNumThanZero(billId);
		if (CollectionUtils.isNotEmpty(stringList)){
			return CommonResponse.error("子表中存在重复的id，请汇总或删除数据！");
		}

		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		SalaryEntity salaryEntity = service.selectById(billId);
		if (salaryEntity != null){
			salaryEntity.setSubmitTime(new Date());

			logger.info("计算个税开始：{}",System.currentTimeMillis());
			detailService.calculateItax(salaryEntity);
			logger.info("计算个税结束：{}",System.currentTimeMillis());
			service.saveOrUpdate(salaryEntity);
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		SalaryEntity salaryEntity = service.selectById(billId);
		if (salaryEntity != null){
			List<SalaryDetailEntity> salaryDetailList = salaryEntity.getSalaryDetailList();

			if (CollectionUtils.isNotEmpty(salaryDetailList)){
				for (SalaryDetailEntity salaryDetailEntity : salaryDetailList) {
					if ("已发放".equals(salaryDetailEntity.getSalaryPayState()) ||
							(!"未申报".equals(salaryDetailEntity.getLastMonthState())) ||
							salaryDetailEntity.getThisMonthItaxYj().compareTo(new BigDecimal(0)) != 0
					){
						return CommonResponse.error("存在已生效的工资单！");
					}
				}
			}

			salaryEntity.setSubmitTime(null);
			service.saveOrUpdate(salaryEntity);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
