package com.ejianc.business.itax.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.itax.bean.SalaryCollectDetailEntity;
/**
 * 工人工资汇总
 * 
 * @author generator
 * 
 */
 @TableName("zzyj_laborservice_itax_salary_collect")
public class SalaryCollectEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="money_sum")
    private String moneySum; // 本次发放总金额
    @TableField(value="itax_sum")
    private String itaxSum; // 本次发放总税额
    @TableField(value="bill_time")
    private Date billTime; // 所属年月
    @TableField(value="create_user_id")
    private Long createUserId; // 创建人id
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="salaryCollectDetailService")
    private List<SalaryCollectDetailEntity> salaryCollectDetailList = new ArrayList<>(); // 工人工资汇总明细
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getMoneySum() {
        return moneySum;
    }

    public void setMoneySum(String moneySum) {
        this.moneySum = moneySum;
    }
    public String getItaxSum() {
        return itaxSum;
    }

    public void setItaxSum(String itaxSum) {
        this.itaxSum = itaxSum;
    }
    public Date getBillTime() {
        return billTime;
    }

    public void setBillTime(Date billTime) {
        this.billTime = billTime;
    }
    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    

    public List<SalaryCollectDetailEntity> getSalaryCollectDetailList() {
        return salaryCollectDetailList;
    }

    public void setSalaryCollectDetailList(List<SalaryCollectDetailEntity> salaryCollectDetailList) {
        this.salaryCollectDetailList = salaryCollectDetailList;
    }
}
