/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.itax.controller;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.itax.bean.WorkerEntity;
import com.ejianc.business.itax.service.IWorkerService;
import com.ejianc.business.itax.utils.DetailIndexExcelReaderZzyj;
import com.ejianc.business.itax.vo.WorkerVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"worker"})
public class WorkerController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IWorkerService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WorkerVO> saveOrUpdate(@RequestBody WorkerVO saveOrUpdateVO) {
        WorkerEntity entity = (WorkerEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, WorkerEntity.class));
        UserContext userContextCache = this.sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setCreateUserName(userContextCache.getUserName());
        } else {
            entity.setUpdateUserName(userContextCache.getUserName());
        }
        entity.setBillCode(entity.getIdNum());
        this.service.saveOrUpdate((Object)entity, false);
        WorkerVO vo = (WorkerVO)BeanMapper.map((Object)((Object)entity), WorkerVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WorkerVO> queryDetail(Long id) {
        WorkerEntity entity = (WorkerEntity)((Object)this.service.selectById(id));
        WorkerVO vo = (WorkerVO)BeanMapper.map((Object)((Object)entity), WorkerVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkerVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (WorkerVO workerVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WorkerVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("idNum");
        fuzzyFields.add("phone");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("state", new Parameter("eq", (Object)1));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WorkerVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Worker-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refWorkerData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WorkerVO>> refWorkerData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WorkerVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/downloadInfo"})
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"workerImport.xlsx", (String)"\u5de5\u4eba\u5bfc\u5165\u6a21\u677f");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportInfo(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<WorkerVO> errorList = new ArrayList<WorkerVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List<List<String>> result = DetailIndexExcelReaderZzyj.readExcel(mf);
        if (result != null && result.size() > 0) {
            int numMax = result.size() > 500 ? 500 : result.size();
            int numMin = 0;
            while (numMax <= result.size()) {
                ArrayList<WorkerVO> successList = new ArrayList<WorkerVO>();
                for (int i = numMin; i < numMax; ++i) {
                    List<String> datas = result.get(i);
                    WorkerVO detailVO = new WorkerVO();
                    detailVO.setId(Long.valueOf(IdWorker.getId()));
                    try {
                        String name = datas.get(0).trim();
                        if (!StringUtils.isNotBlank((CharSequence)name)) {
                            throw new Exception("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        }
                        detailVO.setName(name);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg(e.getMessage());
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        String idNum = datas.get(1).trim();
                        if (!StringUtils.isNotBlank((CharSequence)idNum)) throw new Exception("\u8eab\u4efd\u8bc1\u53f7\u8f93\u5165\u9519\u8bef\uff01");
                        detailVO.setIdNum(idNum);
                        int i1 = Integer.parseInt(idNum.substring(16, 17));
                        if (i1 % 2 == 0) {
                            detailVO.setSex("\u5973");
                        } else {
                            detailVO.setSex("\u7537");
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg(e.getMessage());
                        errorList.add(detailVO);
                        continue;
                    }
                    int type = 0;
                    try {
                        String state = datas.get(3).trim();
                        if (!StringUtils.isNotBlank((CharSequence)state)) throw new Exception("\u4eba\u5458\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        if ("\u6b63\u5e38".equals(state)) {
                            type = 1;
                        } else {
                            if (!"\u975e\u6b63\u5e38".equals(state)) throw new Exception("\u4eba\u5458\u72b6\u6001\u586b\u5199\u9519\u8bef\uff01");
                            type = 2;
                        }
                        detailVO.setType(Integer.valueOf(type));
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg(e.getMessage());
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        String phone = datas.get(4);
                        if (!StringUtils.isNotBlank((CharSequence)phone)) {
                            throw new Exception("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        }
                        detailVO.setPhone(phone);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg(e.getMessage());
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        String date = datas.get(2);
                        if (!StringUtils.isNotBlank((CharSequence)date)) {
                            throw new Exception("\u5de5\u4f5c\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        }
                        DateTime dateTime = DateUtil.parseDate((String)date);
                        detailVO.setEffectiveStartTime((Date)dateTime);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg(e.getMessage());
                        errorList.add(detailVO);
                        continue;
                    }
                    detailVO.setRowState("add");
                    successList.add(detailVO);
                }
                ArrayList<WorkerEntity> successEntityAddList = new ArrayList<WorkerEntity>();
                if (successList.size() > 0) {
                    List idCardList = successList.stream().map(WorkerVO::getIdNum).collect(Collectors.toList());
                    this.logger.info("\u4eba\u5458\u8eab\u4efd\u8bc1\u53f7map: {}", (Object)JSONObject.toJSONString(idCardList));
                    Map<Object, Object> map = new HashMap();
                    LambdaQueryWrapper lambdaQueryWrapper1 = new LambdaQueryWrapper();
                    lambdaQueryWrapper1.eq(WorkerEntity::getState, (Object)1);
                    lambdaQueryWrapper1.in(WorkerEntity::getIdNum, idCardList);
                    lambdaQueryWrapper1.isNotNull(WorkerEntity::getIdNum);
                    List rosterEntityList = this.service.list((Wrapper)lambdaQueryWrapper1);
                    map = rosterEntityList.stream().collect(Collectors.toMap(p -> p.getIdNum(), Function.identity()));
                    for (WorkerVO workerVO : successList) {
                        WorkerEntity workerEntity;
                        if (workerVO.getType() == 1) {
                            if (map.containsKey(workerVO.getIdNum())) {
                                workerVO.setErrorMsg("\u6b64\u4eba\u5458\u5df2\u5728\u5e93\u4e2d\uff01");
                                errorList.add(workerVO);
                                continue;
                            }
                            workerEntity = new WorkerEntity();
                            workerEntity.setName(workerVO.getName());
                            workerEntity.setIdNum(workerVO.getIdNum());
                            workerEntity.setBillCode(workerVO.getIdNum());
                            workerEntity.setPhone(workerVO.getPhone());
                            workerEntity.setEffectiveStartTime(workerVO.getEffectiveStartTime());
                            workerEntity.setSex(workerVO.getSex());
                            workerEntity.setState(1);
                            workerEntity.setBillState(3);
                            workerEntity.setCreateUserName("\u5bfc\u5165\u6570\u636e");
                            successEntityAddList.add(workerEntity);
                            continue;
                        }
                        if (workerVO.getType() != 2) continue;
                        if (map.containsKey(workerVO.getIdNum())) {
                            workerEntity = (WorkerEntity)((Object)map.get(workerVO.getIdNum()));
                            workerEntity.setState(2);
                            workerEntity.setEffectiveEndTime((Date)DateUtil.date());
                            successEntityAddList.add(workerEntity);
                            continue;
                        }
                        workerVO.setErrorMsg("\u6b64\u4eba\u5458\u672a\u5728\u5e93\u4e2d\uff01");
                        errorList.add(workerVO);
                    }
                    if (CollectionUtils.isNotEmpty(successEntityAddList)) {
                        this.service.saveOrUpdateBatch(successEntityAddList);
                    }
                }
                if (numMax == result.size()) break;
                numMin += 500;
                if ((numMax += 500) <= result.size()) continue;
                numMax = result.size();
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", new ArrayList());
        json.put("successList", new ArrayList());
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    public static void main(String[] args) {
        String s = "130321198410265034";
        int i1 = Integer.parseInt(s.substring(16, 17));
        System.out.println(i1 % 2);
        if (i1 % 2 == 0) {
            System.out.println(i1 % 2);
        }
    }
}

