/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.itax.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class IdCardCheck {
    public boolean checkIdCardNum(String idNum) throws ParseException {
        idNum = idNum.toUpperCase();
        String regex = "";
        regex = regex + "^[1-6]\\d{5}";
        regex = regex + "(18|19|20)\\d{2}";
        regex = regex + "((0[1-9])|(1[0-2]))";
        regex = regex + "(([0-2][1-9])|10|20|30|31)";
        regex = regex + "\\d{3}";
        if (!idNum.matches(regex = regex + "[0-9X]")) {
            return false;
        }
        int[] d = new int[]{11, 12, 13, 14, 15, 21, 22, 23, 31, 32, 33, 34, 35, 36, 37, 41, 42, 43, 44, 45, 46, 50, 51, 52, 53, 53, 61, 62, 63, 64, 65, 83, 81, 82};
        boolean flag = false;
        int prov = Integer.parseInt(idNum.substring(0, 2));
        for (int i = 0; i < d.length; ++i) {
            if (d[i] != prov) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Date birthDate = sdf.parse(idNum.substring(6, 14));
        Date curDate = new Date();
        if (birthDate.getTime() > curDate.getTime()) {
            return false;
        }
        int year = Integer.parseInt(idNum.substring(6, 10));
        int leap = year % 4 == 0 && year % 100 != 0 || year % 400 == 0 ? 1 : 0;
        int[] month = new int[]{0, 31, 28 + leap, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int mon = Integer.parseInt(idNum.substring(10, 12));
        int day = Integer.parseInt(idNum.substring(12, 14));
        if (day > month[mon]) {
            return false;
        }
        return idNum.charAt(17) == this.getLastChar(idNum);
    }

    public char getLastChar(String idNum) {
        int[] w = new int[]{0, 7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
        char[] ch = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
        int res = 0;
        for (int i = 0; i < 17; ++i) {
            int t = idNum.charAt(i) - 48;
            res += t * w[i + 1];
        }
        return ch[res % 11];
    }

    public int getYear(String idNum) {
        int yearBirth = Integer.parseInt(idNum.substring(6, 10));
        int monBirth = Integer.parseInt(idNum.substring(10, 12));
        int dayBirth = Integer.parseInt(idNum.substring(12, 14));
        Calendar cur = Calendar.getInstance();
        int yearCur = cur.get(1);
        int monCur = cur.get(2) + 1;
        int dayCur = cur.get(5);
        int age = yearCur - yearBirth;
        if (monCur < monBirth || monCur == monBirth && dayCur < dayBirth) {
            --age;
        }
        return age;
    }

    public int getBirthWeek(String idNum) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Date birthDate = sdf.parse(idNum.substring(6, 14));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(birthDate);
        return calendar.get(3);
    }

    public int getWeeks(String idNum) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Date birthDate = sdf.parse(idNum.substring(6, 14));
        Date curDate = new Date();
        return (int)((curDate.getTime() - birthDate.getTime()) / 604800000L);
    }
}

