/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.laborservice.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.laborservice.bean.LaborserviceProjectEntity;
import com.ejianc.business.laborservice.service.ILaborserviceProjectService;
import com.ejianc.business.laborservice.utils.AddressResolutionUtil;
import com.ejianc.business.laborservice.utils.EJCDateUtil;
import com.ejianc.business.laborservice.vo.AreaDataVO;
import com.ejianc.business.laborservice.vo.InfoAreaVO;
import com.ejianc.business.laborservice.vo.LaborserviceProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"laborserviceProject"})
public class LaborserviceProjectController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "\u52b3\u52a1-\u9879\u76ee\u4fe1\u606f\u7ba1\u7406";
    @Autowired
    private ILaborserviceProjectService service;
    @Autowired
    private SessionManager sessionManager;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<LaborserviceProjectVO> saveOrUpdate(@RequestBody LaborserviceProjectVO saveOrUpdateVO) {
        LaborserviceProjectEntity entity = (LaborserviceProjectEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, LaborserviceProjectEntity.class));
        UserContext userContextCache = this.sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else {
            entity.setUpdateUserName(userContextCache.getUserName());
        }
        this.service.saveOrUpdate((Object)entity, false);
        LaborserviceProjectVO vo = (LaborserviceProjectVO)BeanMapper.map((Object)((Object)entity), LaborserviceProjectVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<LaborserviceProjectVO> queryDetail(Long id) {
        LaborserviceProjectEntity entity = (LaborserviceProjectEntity)((Object)this.service.selectById(id));
        LaborserviceProjectVO vo = (LaborserviceProjectVO)BeanMapper.map((Object)((Object)entity), LaborserviceProjectVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LaborserviceProjectVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (LaborserviceProjectVO laborserviceProjectVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<LaborserviceProjectVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("registCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), LaborserviceProjectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("LaborserviceProject-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refLaborserviceProjectData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<LaborserviceProjectVO>> refLaborserviceProjectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("unitName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        LinkedHashMap orderMap = param.getOrderMap();
        orderMap.put("createTime", "desc");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (_con = JSONObject.parseObject((String)condition)).get((Object)"projectStatus")) {
            param.getParams().put("projectStatus", new Parameter("eq", (Object)_con.getString("projectStatus")));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), LaborserviceProjectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"getIdByProjectId"})
    @ResponseBody
    public CommonResponse<LaborserviceProjectVO> getIdByProjectId(@RequestParam(value="projectId") String projectId) {
        LaborserviceProjectEntity entity = this.service.getIdByProjectId(projectId);
        if (entity != null) {
            LaborserviceProjectVO projectVO = (LaborserviceProjectVO)BeanMapper.map((Object)((Object)entity), LaborserviceProjectVO.class);
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)projectVO);
        }
        return CommonResponse.error((String)"\u672a\u627e\u5230\u6570\u636e\uff01");
    }

    @RequestMapping(value={"/getInfoArea"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getInfoArea(@RequestParam(value="name", required=false) String name, @RequestParam(value="dateIn", required=false) String dateIn, @RequestParam(value="orgId", required=false) Long orgId) {
        return this.infoArea(name, dateIn, orgId);
    }

    public CommonResponse<JSONObject> infoArea(String name, String dateIn, Long orgId) {
        Map<String, List<InfoAreaVO>> map;
        dateIn = EJCDateUtil.getYear() + "";
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)dateIn)) {
            queryWrapper.eq((Object)"DATE_FORMAT(create_time,\"%Y\")", (Object)dateIn);
        }
        queryWrapper.in((Object)"bill_state", Arrays.asList(1, 3));
        List list = this.service.list((Wrapper)queryWrapper);
        ArrayList<InfoAreaVO> infoAreaVOS = new ArrayList<InfoAreaVO>();
        if (ListUtil.isNotEmpty((List)list)) {
            List infoRegisterVOS = BeanMapper.mapList((Iterable)list, LaborserviceProjectVO.class);
            for (LaborserviceProjectVO infoRegisterVO : infoRegisterVOS) {
                InfoAreaVO infoAreaVO = new InfoAreaVO();
                infoAreaVO.setId(infoRegisterVO.getId());
                infoAreaVO.setOrgId(infoRegisterVO.getOrgId());
                infoAreaVO.setCourtName(infoRegisterVO.getProjectName());
                if (StringUtils.isNotEmpty((CharSequence)infoRegisterVO.getAreaName())) {
                    String areaName = null;
                    areaName = infoRegisterVO.getAreaName().replace("/", "");
                    infoAreaVO.setAreaName(areaName);
                } else {
                    infoAreaVO.setAreaName(infoRegisterVO.getAreaName());
                }
                infoAreaVOS.add(infoAreaVO);
            }
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        HashSet<Object> provinceSet = new HashSet<Object>();
        HashSet<String> citySet = new HashSet<String>();
        HashSet<String> countySet = new HashSet<String>();
        String pname = null;
        for (InfoAreaVO vo : infoAreaVOS) {
            ids.add(vo.getId());
            if (StringUtils.isNotEmpty((CharSequence)vo.getAreaName())) {
                if (vo.getAreaName().equals("\u53f0\u6e7e\u7701")) {
                    vo.setProvince("\u53f0\u6e7e\u7701");
                    vo.setCity("\u53f0\u6e7e\u7701");
                    vo.setCounty("\u53f0\u6e7e\u7701");
                    provinceSet.add("\u53f0\u6e7e\u7701");
                    citySet.add("\u53f0\u6e7e\u7701");
                    countySet.add("\u53f0\u6e7e\u7701");
                    continue;
                }
                Map<String, String> areaMap = AddressResolutionUtil.addressResolution(vo.getAreaName());
                if (areaMap != null) {
                    String province = areaMap.get("province") == null ? "\u5176\u4ed6" : areaMap.get("province");
                    String string = areaMap.get("city") == null ? "\u5176\u4ed6" : areaMap.get("city");
                    String string2 = areaMap.get("county") == null ? "\u5176\u4ed6" : areaMap.get("county");
                    vo.setProvince(province);
                    vo.setCity(string);
                    vo.setCounty(string2);
                    provinceSet.add(province);
                    citySet.add(string);
                    countySet.add(string2);
                    if (!StringUtils.isNotBlank((CharSequence)name) || !string.equals(name)) continue;
                    pname = province;
                    continue;
                }
                vo.setProvince("\u5176\u4ed6");
                vo.setCity("\u5176\u4ed6");
                vo.setCounty("\u5176\u4ed6");
                provinceSet.add("\u5176\u4ed6");
                citySet.add("\u5176\u4ed6");
                countySet.add("\u5176\u4ed6");
                continue;
            }
            vo.setProvince("\u5176\u4ed6");
            vo.setCity("\u5176\u4ed6");
            vo.setCounty("\u5176\u4ed6");
            provinceSet.add("\u5176\u4ed6");
            citySet.add("\u5176\u4ed6");
            countySet.add("\u5176\u4ed6");
        }
        String rangeType = null;
        List<Object> dataVOS = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            if (provinceSet.contains(name)) {
                rangeType = AddressResolutionUtil.getProvincePinYin(name);
                dataVOS = this.projectCountByName(name, infoAreaVOS, 0);
            } else if (citySet.contains(name)) {
                rangeType = AddressResolutionUtil.getProvincePinYin(pname) + "-" + AddressResolutionUtil.getNamePinYinChar(name, 1);
                dataVOS = this.projectCountByName(name, infoAreaVOS, 1);
            }
        } else if (provinceSet.size() == 1) {
            if (citySet.size() == 1) {
                rangeType = AddressResolutionUtil.getProvincePinYin((String)provinceSet.iterator().next()) + "-" + AddressResolutionUtil.getNamePinYinChar((String)citySet.iterator().next(), 1);
                HashMap<String, AreaDataVO> countyMap = new HashMap<String, AreaDataVO>();
                for (InfoAreaVO infoAreaVO : infoAreaVOS) {
                    String string = infoAreaVO.getCounty();
                    if (!countyMap.containsKey(string)) {
                        AreaDataVO pvo = new AreaDataVO();
                        pvo.setName(string);
                        pvo.setValue(Integer.valueOf(1));
                        countyMap.put(string, pvo);
                        continue;
                    }
                    AreaDataVO projectDataVO = (AreaDataVO)countyMap.get(string);
                    projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
                    countyMap.put(string, projectDataVO);
                }
                dataVOS = new ArrayList(countyMap.values());
                map = infoAreaVOS.stream().collect(Collectors.groupingBy(InfoAreaVO::getCounty));
                for (AreaDataVO areaDataVO : dataVOS) {
                    if (!map.containsKey(areaDataVO.getName())) continue;
                    List<InfoAreaVO> projectCountVOS = map.get(areaDataVO.getName());
                    areaDataVO.setInfoAreaVOS(projectCountVOS);
                }
            } else {
                rangeType = AddressResolutionUtil.getProvincePinYin((String)provinceSet.iterator().next());
                HashMap<String, AreaDataVO> cityMap = new HashMap<String, AreaDataVO>();
                for (InfoAreaVO infoAreaVO : infoAreaVOS) {
                    String string = infoAreaVO.getCity();
                    if (!cityMap.containsKey(string)) {
                        AreaDataVO pvo = new AreaDataVO();
                        pvo.setName(string);
                        pvo.setValue(Integer.valueOf(1));
                        cityMap.put(string, pvo);
                        continue;
                    }
                    AreaDataVO projectDataVO = (AreaDataVO)cityMap.get(string);
                    projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
                    cityMap.put(string, projectDataVO);
                }
                dataVOS = new ArrayList(cityMap.values());
                map = infoAreaVOS.stream().collect(Collectors.groupingBy(InfoAreaVO::getCity));
                for (AreaDataVO areaDataVO : dataVOS) {
                    if (!map.containsKey(areaDataVO.getName())) continue;
                    List<InfoAreaVO> projectCountVOS = map.get(areaDataVO.getName());
                    areaDataVO.setInfoAreaVOS(projectCountVOS);
                }
            }
        } else {
            rangeType = "China";
            HashMap<String, AreaDataVO> provinceMap = new HashMap<String, AreaDataVO>();
            for (InfoAreaVO infoAreaVO : infoAreaVOS) {
                String string = infoAreaVO.getProvince();
                if (!provinceMap.containsKey(string)) {
                    AreaDataVO pvo = new AreaDataVO();
                    pvo.setName(string);
                    pvo.setValue(Integer.valueOf(1));
                    provinceMap.put(string, pvo);
                    continue;
                }
                AreaDataVO projectDataVO = (AreaDataVO)provinceMap.get(string);
                projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
                provinceMap.put(string, projectDataVO);
            }
            map = infoAreaVOS.stream().collect(Collectors.groupingBy(InfoAreaVO::getProvince));
            dataVOS = new ArrayList(provinceMap.values());
            for (AreaDataVO areaDataVO : dataVOS) {
                if (!map.containsKey(areaDataVO.getName())) continue;
                List<InfoAreaVO> projectCountVOS = map.get(areaDataVO.getName());
                areaDataVO.setInfoAreaVOS(projectCountVOS);
            }
        }
        JSONObject jsonObject = new JSONObject();
        if (CollectionUtils.isNotEmpty(dataVOS)) {
            Collections.sort(dataVOS, new Comparator<AreaDataVO>(){

                @Override
                public int compare(AreaDataVO o1, AreaDataVO o2) {
                    int a = "\u5176\u4ed6".equals(o1.getName()) ? 100000 : o1.getValue();
                    int b = "\u5176\u4ed6".equals(o2.getName()) ? 100000 : o1.getValue();
                    return a - b;
                }
            });
        }
        if (rangeType != null) {
            if (rangeType.contains("beijing")) {
                rangeType = "beijing";
            } else if (rangeType.contains("shanghai")) {
                rangeType = "beijing";
            } else if (rangeType.contains("chongqing")) {
                rangeType = "chongqing";
            } else if (rangeType.contains("tianjin")) {
                rangeType = "tianjin";
            }
        }
        if (rangeType == null || rangeType.contains("null")) {
            rangeType = "China";
        }
        jsonObject.put("range", (Object)(rangeType == null || rangeType.contains("null") ? "China" : rangeType));
        ArrayList projectDataVOS = new ArrayList();
        jsonObject.put("data", dataVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    private List<AreaDataVO> projectCountByName(String name, List<InfoAreaVO> list, Integer type) {
        ArrayList dataVOS = new ArrayList();
        HashMap<String, AreaDataVO> map = new HashMap<String, AreaDataVO>();
        for (InfoAreaVO vo : list) {
            String voName = null;
            String childrenName = null;
            if (type == 0) {
                voName = vo.getProvince();
                childrenName = vo.getCity();
            } else {
                voName = vo.getCity();
                childrenName = vo.getCounty();
            }
            if (!voName.equals(name)) continue;
            if (!map.containsKey(childrenName)) {
                AreaDataVO pvo = new AreaDataVO();
                pvo.setName(childrenName);
                pvo.setValue(Integer.valueOf(1));
                map.put(childrenName, pvo);
                continue;
            }
            AreaDataVO projectDataVO = (AreaDataVO)map.get(childrenName);
            projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
            map.put(childrenName, projectDataVO);
        }
        Map<String, List<InfoAreaVO>> projectCountVOMap = null;
        projectCountVOMap = type == 0 ? list.stream().collect(Collectors.groupingBy(InfoAreaVO::getCity)) : list.stream().collect(Collectors.groupingBy(InfoAreaVO::getCounty));
        ArrayList<AreaDataVO> projectDataVOS = new ArrayList<AreaDataVO>(map.values());
        for (AreaDataVO dataVO : projectDataVOS) {
            if (!map.containsKey(dataVO.getName())) continue;
            List<InfoAreaVO> projectCountVOS = projectCountVOMap.get(dataVO.getName());
            dataVO.setInfoAreaVOS(projectCountVOS);
        }
        return projectDataVOS;
    }
}

