package com.ejianc.business.laborservice.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 劳务公司发票信息
 * 
 * @author generator
 * 
 */
 @TableName("zzyj_laborservice_invoice_info")
public class LaborserviceInvoiceInfoEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="invoice_type")
    private String invoiceType; // 发票类型
    @TableField(value="invoice_num")
    private String invoiceNum; // 发票票号
    @TableField(value="invoice_code")
    private String invoiceCode; // 发票代码
    @TableField(value="invoicing_date")
    private Date invoicingDate; // 开票日期
    @TableField(value="amount_mny")
    private BigDecimal amountMny; // 金额
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="tax_amount")
    private BigDecimal taxAmount; // 税额
    @TableField(value="amount_including_tax")
    private BigDecimal amountIncludingTax; // 含税金额
    @TableField(value="invoice_receiver_id")
    private Long invoiceReceiverId; // 发票接收人id
    @TableField(value="invoice_receiver_name")
    private String invoiceReceiverName; // 发票接收人
    @TableField(value="receive_date")
    private Date receiveDate; // 接收日期
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="project_manager_dept_id")
    private Long projectManagerDeptId; // 单位id
    @TableField(value="project_manager_dept")
    private String projectManagerDept; // 单位名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_address")
    private String projectAddress; // 项目地址
    @TableField(value="invoice_amount")
    private BigDecimal invoiceAmount; // 开票金额
    @TableField(value="vat")
    private BigDecimal vat; // 增值税
    @TableField(value="management_fees")
    private BigDecimal managementFees; // 管理费
    @TableField(value="supplier_signer")
    private String supplierSigner; // 劳务队长
    @TableField(value="main_task_amount")
    private BigDecimal mainTaskAmount; // 主营业务收入
    @TableField(value="service_fee_income")
    private BigDecimal serviceFeeIncome; // 劳务费收入
    @TableField(value="city_maintenance_tax")
    private BigDecimal cityMaintenanceTax; // 城市维护建设税
    @TableField(value="edu_fee_add")
    private BigDecimal eduFeeAdd; // 教育费附加
    @TableField(value="area_edu_add")
    private BigDecimal areaEduAdd; // 地方教育附加
    @TableField(value="stamp_tax")
    private BigDecimal stampTax; // 印花税
    @TableField(value="invoice_status")
    private String invoiceStatus; // 发票状态
    @TableField(value = "source_contract_id")
    private String sourceContractId;//关联合同id
    @TableField(value="area_id")
    private String areaId; // 地区
    @TableField(value="area_name")
    private String areaName; // 地区名称
    @TableField(value="income_contract_tax_mny")
    private BigDecimal incomeContractTaxMny; // 收入合同金额
    @TableField(value="sum_invoice_amount")
    private BigDecimal sumInvoiceAmount; // 累计开票金额
    @TableField(value="remote_vat")
    private BigDecimal remoteVat; // 异地增值税
    @TableField(value="remote_vat_rate")
    private BigDecimal remoteVatRate; // 异地增值税税率
    @TableField(value="remote_city_construction_tax")
    private BigDecimal remoteCityConstructionTax; // 异地城建税
    @TableField(value="remote_education_addition")
    private BigDecimal remoteEducationAddition; // 异地教育费附加
    @TableField(value="remote_local_education_addition")
    private BigDecimal remoteLocalEducationAddition; // 异地地方教育费附加
    @TableField(value="remote_stamp_tax")
    private BigDecimal remoteStampTax; // 异地印花税
    @TableField(value="remote_fund")
    private BigDecimal remoteFund; // 异地基金
    @TableField(value="remote_personal_income_tax")
    private BigDecimal remotePersonalIncomeTax; // 异地个人所得税
    @TableField(value="remote_corporate_income_tax")
    private BigDecimal remoteCorporateIncomeTax; // 异地企业所得税
    @TableField(value="remote_water_construction_income")
    private BigDecimal remoteWaterConstructionIncome; // 异地水建收入
    @TableField(value="remote_env_protection_tax")
    private BigDecimal remoteEnvProtectionTax; // 异地环保税
    @TableField(value="remote_water_resources")
    private BigDecimal remoteWaterResources; // 异地水资源
    @TableField(value="remote_other_items")
    private BigDecimal remoteOtherItems; // 异地其他项目
    @TableField(value="remote_additional_tax_total")
    private BigDecimal remoteAdditionalTaxTotal; // 异地附加税合计
    @TableField(value="remote_tax_total")
    private BigDecimal remoteTaxTotal; // 异地税费合计
    @TableField(value="remote_national_tax_paid_date")
    private Date remoteNationalTaxPaidDate; // 异地国税完税日期
    @TableField(value="remote_national_tax_payment_cert_num")
    private String remoteNationalTaxPaymentCertNum; // 异地国税完税凭证号
    @TableField(value="remote_national_tax_payment_org_id")
    private String remoteNationalTaxPaymentOrgId; // 异地国税完税机构Id
    @TableField(value="remote_national_tax_payment_org_name")
    private String remoteNationalTaxPaymentOrgName; // 异地国税完税机构名称
    @TableField(value="simple_tax_calculation")
    private BigDecimal simpleTaxCalculation; // 5%简易计税
    @TableField(value="management_rate")
    private BigDecimal managementRate; // 管理费率%
    @TableField(value="income_contract_code")
    private String incomeContractCode; // 收入合同编号
    @TableField(value="memo")
    private String memo; // 发票备注
    @TableField(value="invoice_issuing_entity")
    private String invoiceIssuingEntity; // 开票单位
    @TableField(value="invoice_issuing_entity_id")
    private Long invoiceIssuingEntityId; // 开票单位id
    @TableField(value="labor_fee")
    private BigDecimal laborFee; // 劳务费收据
    @TableField(value="sum_labor_fee")
    private BigDecimal sumLaborFee; // 累计已开劳务费收据

    @TableField(exist=false)
    @SubEntity(serviceName="laborserviceInvoiceInfoZiService",pidName = "pid")
    private List<LaborserviceInvoiceInfoZiEntity> laborserviceInvoiceInfoZiList = new ArrayList<>(); // 发票信息异地子表
    @TableField(value="by_number")
    private String byNumber; // 报验编号


    public String getByNumber() {
        return byNumber;
    }

    public void setByNumber(String byNumber) {
        this.byNumber = byNumber;
    }

    public List<LaborserviceInvoiceInfoZiEntity> getLaborserviceInvoiceInfoZiList() {
        return laborserviceInvoiceInfoZiList;
    }

    public void setLaborserviceInvoiceInfoZiList(List<LaborserviceInvoiceInfoZiEntity> laborserviceInvoiceInfoZiList) {
        this.laborserviceInvoiceInfoZiList = laborserviceInvoiceInfoZiList;
    }

    public BigDecimal getLaborFee() {
        return laborFee;
    }

    public void setLaborFee(BigDecimal laborFee) {
        this.laborFee = laborFee;
    }

    public BigDecimal getSumLaborFee() {
        return sumLaborFee;
    }

    public void setSumLaborFee(BigDecimal sumLaborFee) {
        this.sumLaborFee = sumLaborFee;
    }

    public String getInvoiceIssuingEntity() {
        return invoiceIssuingEntity;
    }

    public void setInvoiceIssuingEntity(String invoiceIssuingEntity) {
        this.invoiceIssuingEntity = invoiceIssuingEntity;
    }

    public Long getInvoiceIssuingEntityId() {
        return invoiceIssuingEntityId;
    }

    public void setInvoiceIssuingEntityId(Long invoiceIssuingEntityId) {
        this.invoiceIssuingEntityId = invoiceIssuingEntityId;
    }

    public String getIncomeContractCode() {
        return incomeContractCode;
    }

    public void setIncomeContractCode(String incomeContractCode) {
        this.incomeContractCode = incomeContractCode;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getManagementRate() {
        return managementRate;
    }

    public void setManagementRate(BigDecimal managementRate) {
        this.managementRate = managementRate;
    }

    public BigDecimal getSimpleTaxCalculation() {
        return simpleTaxCalculation;
    }

    public void setSimpleTaxCalculation(BigDecimal simpleTaxCalculation) {
        this.simpleTaxCalculation = simpleTaxCalculation;
    }

    public BigDecimal getRemoteVat() {
        return remoteVat;
    }

    public void setRemoteVat(BigDecimal remoteVat) {
        this.remoteVat = remoteVat;
    }

    public BigDecimal getRemoteVatRate() {
        return remoteVatRate;
    }

    public void setRemoteVatRate(BigDecimal remoteVatRate) {
        this.remoteVatRate = remoteVatRate;
    }

    public BigDecimal getRemoteCityConstructionTax() {
        return remoteCityConstructionTax;
    }

    public void setRemoteCityConstructionTax(BigDecimal remoteCityConstructionTax) {
        this.remoteCityConstructionTax = remoteCityConstructionTax;
    }

    public BigDecimal getRemoteEducationAddition() {
        return remoteEducationAddition;
    }

    public void setRemoteEducationAddition(BigDecimal remoteEducationAddition) {
        this.remoteEducationAddition = remoteEducationAddition;
    }

    public BigDecimal getRemoteLocalEducationAddition() {
        return remoteLocalEducationAddition;
    }

    public void setRemoteLocalEducationAddition(BigDecimal remoteLocalEducationAddition) {
        this.remoteLocalEducationAddition = remoteLocalEducationAddition;
    }

    public BigDecimal getRemoteStampTax() {
        return remoteStampTax;
    }

    public void setRemoteStampTax(BigDecimal remoteStampTax) {
        this.remoteStampTax = remoteStampTax;
    }

    public BigDecimal getRemoteFund() {
        return remoteFund;
    }

    public void setRemoteFund(BigDecimal remoteFund) {
        this.remoteFund = remoteFund;
    }

    public BigDecimal getRemotePersonalIncomeTax() {
        return remotePersonalIncomeTax;
    }

    public void setRemotePersonalIncomeTax(BigDecimal remotePersonalIncomeTax) {
        this.remotePersonalIncomeTax = remotePersonalIncomeTax;
    }

    public BigDecimal getRemoteCorporateIncomeTax() {
        return remoteCorporateIncomeTax;
    }

    public void setRemoteCorporateIncomeTax(BigDecimal remoteCorporateIncomeTax) {
        this.remoteCorporateIncomeTax = remoteCorporateIncomeTax;
    }

    public BigDecimal getRemoteWaterConstructionIncome() {
        return remoteWaterConstructionIncome;
    }

    public void setRemoteWaterConstructionIncome(BigDecimal remoteWaterConstructionIncome) {
        this.remoteWaterConstructionIncome = remoteWaterConstructionIncome;
    }

    public BigDecimal getRemoteEnvProtectionTax() {
        return remoteEnvProtectionTax;
    }

    public void setRemoteEnvProtectionTax(BigDecimal remoteEnvProtectionTax) {
        this.remoteEnvProtectionTax = remoteEnvProtectionTax;
    }

    public BigDecimal getRemoteWaterResources() {
        return remoteWaterResources;
    }

    public void setRemoteWaterResources(BigDecimal remoteWaterResources) {
        this.remoteWaterResources = remoteWaterResources;
    }

    public BigDecimal getRemoteOtherItems() {
        return remoteOtherItems;
    }

    public void setRemoteOtherItems(BigDecimal remoteOtherItems) {
        this.remoteOtherItems = remoteOtherItems;
    }

    public BigDecimal getRemoteAdditionalTaxTotal() {
        return remoteAdditionalTaxTotal;
    }

    public void setRemoteAdditionalTaxTotal(BigDecimal remoteAdditionalTaxTotal) {
        this.remoteAdditionalTaxTotal = remoteAdditionalTaxTotal;
    }

    public BigDecimal getRemoteTaxTotal() {
        return remoteTaxTotal;
    }

    public void setRemoteTaxTotal(BigDecimal remoteTaxTotal) {
        this.remoteTaxTotal = remoteTaxTotal;
    }

    public Date getRemoteNationalTaxPaidDate() {
        return remoteNationalTaxPaidDate;
    }

    public void setRemoteNationalTaxPaidDate(Date remoteNationalTaxPaidDate) {
        this.remoteNationalTaxPaidDate = remoteNationalTaxPaidDate;
    }

    public String getRemoteNationalTaxPaymentCertNum() {
        return remoteNationalTaxPaymentCertNum;
    }

    public void setRemoteNationalTaxPaymentCertNum(String remoteNationalTaxPaymentCertNum) {
        this.remoteNationalTaxPaymentCertNum = remoteNationalTaxPaymentCertNum;
    }

    public String getRemoteNationalTaxPaymentOrgId() {
        return remoteNationalTaxPaymentOrgId;
    }

    public void setRemoteNationalTaxPaymentOrgId(String remoteNationalTaxPaymentOrgId) {
        this.remoteNationalTaxPaymentOrgId = remoteNationalTaxPaymentOrgId;
    }

    public String getRemoteNationalTaxPaymentOrgName() {
        return remoteNationalTaxPaymentOrgName;
    }

    public void setRemoteNationalTaxPaymentOrgName(String remoteNationalTaxPaymentOrgName) {
        this.remoteNationalTaxPaymentOrgName = remoteNationalTaxPaymentOrgName;
    }

    public BigDecimal getIncomeContractTaxMny() {
        return incomeContractTaxMny;
    }

    public void setIncomeContractTaxMny(BigDecimal incomeContractTaxMny) {
        this.incomeContractTaxMny = incomeContractTaxMny;
    }

    public BigDecimal getSumInvoiceAmount() {
        return sumInvoiceAmount;
    }

    public void setSumInvoiceAmount(BigDecimal sumInvoiceAmount) {
        this.sumInvoiceAmount = sumInvoiceAmount;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }
    public String getInvoiceNum() {
        return invoiceNum;
    }

    public void setInvoiceNum(String invoiceNum) {
        this.invoiceNum = invoiceNum;
    }
    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }
    public Date getInvoicingDate() {
        return invoicingDate;
    }

    public void setInvoicingDate(Date invoicingDate) {
        this.invoicingDate = invoicingDate;
    }
    public BigDecimal getAmountMny() {
        return amountMny;
    }

    public void setAmountMny(BigDecimal amountMny) {
        this.amountMny = amountMny;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }
    public BigDecimal getAmountIncludingTax() {
        return amountIncludingTax;
    }

    public void setAmountIncludingTax(BigDecimal amountIncludingTax) {
        this.amountIncludingTax = amountIncludingTax;
    }
    public Long getInvoiceReceiverId() {
        return invoiceReceiverId;
    }

    public void setInvoiceReceiverId(Long invoiceReceiverId) {
        this.invoiceReceiverId = invoiceReceiverId;
    }
    public String getInvoiceReceiverName() {
        return invoiceReceiverName;
    }

    public void setInvoiceReceiverName(String invoiceReceiverName) {
        this.invoiceReceiverName = invoiceReceiverName;
    }
    public Date getReceiveDate() {
        return receiveDate;
    }

    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getProjectManagerDeptId() {
        return projectManagerDeptId;
    }

    public void setProjectManagerDeptId(Long projectManagerDeptId) {
        this.projectManagerDeptId = projectManagerDeptId;
    }
    public String getProjectManagerDept() {
        return projectManagerDept;
    }

    public void setProjectManagerDept(String projectManagerDept) {
        this.projectManagerDept = projectManagerDept;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
    public BigDecimal getInvoiceAmount() {
        return invoiceAmount;
    }

    public void setInvoiceAmount(BigDecimal invoiceAmount) {
        this.invoiceAmount = invoiceAmount;
    }
    public BigDecimal getVat() {
        return vat;
    }

    public void setVat(BigDecimal vat) {
        this.vat = vat;
    }
    public BigDecimal getManagementFees() {
        return managementFees;
    }

    public void setManagementFees(BigDecimal managementFees) {
        this.managementFees = managementFees;
    }
    public String getSupplierSigner() {
        return supplierSigner;
    }

    public void setSupplierSigner(String supplierSigner) {
        this.supplierSigner = supplierSigner;
    }
    public BigDecimal getMainTaskAmount() {
        return mainTaskAmount;
    }

    public void setMainTaskAmount(BigDecimal mainTaskAmount) {
        this.mainTaskAmount = mainTaskAmount;
    }
    public BigDecimal getServiceFeeIncome() {
        return serviceFeeIncome;
    }

    public void setServiceFeeIncome(BigDecimal serviceFeeIncome) {
        this.serviceFeeIncome = serviceFeeIncome;
    }
    public BigDecimal getCityMaintenanceTax() {
        return cityMaintenanceTax;
    }

    public void setCityMaintenanceTax(BigDecimal cityMaintenanceTax) {
        this.cityMaintenanceTax = cityMaintenanceTax;
    }
    public BigDecimal getEduFeeAdd() {
        return eduFeeAdd;
    }

    public void setEduFeeAdd(BigDecimal eduFeeAdd) {
        this.eduFeeAdd = eduFeeAdd;
    }
    public BigDecimal getAreaEduAdd() {
        return areaEduAdd;
    }

    public void setAreaEduAdd(BigDecimal areaEduAdd) {
        this.areaEduAdd = areaEduAdd;
    }
    public BigDecimal getStampTax() {
        return stampTax;
    }

    public void setStampTax(BigDecimal stampTax) {
        this.stampTax = stampTax;
    }
    public String getInvoiceStatus() {
        return invoiceStatus;
    }

    public void setInvoiceStatus(String invoiceStatus) {
        this.invoiceStatus = invoiceStatus;
    }

    public String getSourceContractId() {
        return sourceContractId;
    }

    public void setSourceContractId(String sourceContractId) {
        this.sourceContractId = sourceContractId;
    }

    public String getAreaId() {
        return areaId;
    }

    public void setAreaId(String areaId) {
        this.areaId = areaId;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }
}
