package com.ejianc.business.laborservice.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.laborservice.bean.LaborserviceIncomeContractEntity;
import com.ejianc.business.laborservice.bean.LaborserviceProjectEntity;
import com.ejianc.business.laborservice.mapper.LaborserviceProjectMapper;
import com.ejianc.business.laborservice.service.ILaborserviceProjectService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;

/**
 * 劳务公司项目
 * 
 * @author generator
 * 
 */
@Service("laborserviceProjectService")
public class LaborserviceProjectServiceImpl extends BaseServiceImpl<LaborserviceProjectMapper, LaborserviceProjectEntity> implements ILaborserviceProjectService {
    public LaborserviceProjectEntity getIdByProjectId(String projectId){
        LambdaQueryWrapper<LaborserviceProjectEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(LaborserviceProjectEntity::getProjectId, projectId);
        List<LaborserviceProjectEntity> entityList = baseMapper.selectList(wrapper);
        if (CollectionUtils.isNotEmpty(entityList)) {
            return entityList.get(0);
        } else {
            return null;
        }
    }
}
