package com.ejianc.business.oa.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.oa.bean.ExpenseClaimDetailEntity;
/**
 * 费用支出申请表
 * 
 * @author generator
 * 
 */
 @TableName("zzyj_laborservice_expense_claim")
public class ExpenseClaimEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="is_report")
    private Integer isReport; // 是否上报总公司（1是0否）
    @TableField(value="unit_id")
    private Long unitId; // 所在单位id
    @TableField(value="unit_name")
    private String unitName; // 所在单位
    @TableField(value="apply_user_id")
    private Long applyUserId; // 申请人ID
    @TableField(value="apply_user_name")
    private String applyUserName; // 申请人姓名
    @TableField(value="apply_time")
    private Date applyTime; // 申请时间
    @TableField(value="project_info")
    private String projectInfo; // 涉及项目情况
    @TableField(value="expend_type")
    private String expendType; // 支出类型
    @TableField(value="expend_mny")
    private BigDecimal expendMny; // 总金额
    @TableField(value="expend_mny_month")
    private BigDecimal expendMnyMonth; // 月度总金额
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="expenseClaimDetailService")
    private List<ExpenseClaimDetailEntity> expenseClaimDetailList = new ArrayList<>(); // 费用支出申请子表


    public BigDecimal getExpendMnyMonth() {
        return expendMnyMonth;
    }

    public void setExpendMnyMonth(BigDecimal expendMnyMonth) {
        this.expendMnyMonth = expendMnyMonth;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getIsReport() {
        return isReport;
    }

    public void setIsReport(Integer isReport) {
        this.isReport = isReport;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public Long getApplyUserId() {
        return applyUserId;
    }

    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }
    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }
    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }
    public String getProjectInfo() {
        return projectInfo;
    }

    public void setProjectInfo(String projectInfo) {
        this.projectInfo = projectInfo;
    }
    public String getExpendType() {
        return expendType;
    }

    public void setExpendType(String expendType) {
        this.expendType = expendType;
    }
    public BigDecimal getExpendMny() {
        return expendMny;
    }

    public void setExpendMny(BigDecimal expendMny) {
        this.expendMny = expendMny;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    

    public List<ExpenseClaimDetailEntity> getExpenseClaimDetailList() {
        return expenseClaimDetailList;
    }

    public void setExpenseClaimDetailList(List<ExpenseClaimDetailEntity> expenseClaimDetailList) {
        this.expenseClaimDetailList = expenseClaimDetailList;
    }
}
