package com.ejianc.business.laborservice.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.laborservice.vo.LaborserviceExpendContractVO;
import com.ejianc.business.laborservice.vo.LaborserviceIncomeContractVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.laborservice.bean.LaborserviceIncomeContractEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;

/**
 * 劳务公司收入合同
 * 
 * @author generator
 * 
 */
@Mapper
public interface LaborserviceIncomeContractMapper extends BaseCrudMapper<LaborserviceIncomeContractEntity> {

    @Select({
            "select *  from zzyj_laborservice_income_contract where supplier_signer_id=#{teamId} and project_id = #{projectId}"
    })
    List<LaborserviceIncomeContractVO> getUnionContractInfo(@RequestParam String teamId,@RequestParam Long projectId);

    @Select({
            "select * from zzyj_laborservice_expend_contract where income_contract_id=#{id}"
    })
    List<LaborserviceExpendContractVO> queryExpendList(@RequestParam Long id);


    List<LaborserviceIncomeContractVO> listContractLedger(@Param(Constants.WRAPPER) QueryWrapper<Object> changeToQueryWrapper, @Param("page") IPage<LaborserviceIncomeContractVO> page);

    @Update("update `zzyj_laborservice_income_contract` set is_sign_expend_contract = #{isSign},sign_expend_contract_id =  #{expendContractId} where id = #{enrollId} and dr = 0 ")
    Boolean updateSignState(@Param("enrollId") Long enrollId, @Param("isSign") Integer isSign,@Param("expendContractId") Long expendContractId);

}
