/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.desktop.api.IShareCategoryApi;
import com.ejianc.business.oa.bean.LeaveEntity;
import com.ejianc.business.oa.service.ILeaveService;
import com.ejianc.business.oa.vo.LeaveVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"leave"})
public class LeaveController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ILeaveService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareCategoryApi shareCategoryApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    static String TEST_AGENTID = "1000038";
    static String TEST_SECRET = "0n0MCtZ1vNtJsKQWPIREQ1UNMM8BXDkQZat6nbRqGGE";
    static String PRO_AGENTID = "1000036";
    static String PRO_SECRET = "dBMuo3hXenzW-6B3U8BfscMDQWSr3ET1nfwUaqDPi40";

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<LeaveVO> queryDetail(Long id) {
        LeaveEntity entity = (LeaveEntity)this.service.selectById(id);
        LeaveVO vo = (LeaveVO)BeanMapper.map((Object)entity, LeaveVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<LeaveVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("userName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("type");
        UserContext userContextCache = this.sessionManager.getUserContext();
        this.logger.info("\u60a8\u7684\u90e8\u95e8id\u540d\u79f0{}", (Object)(userContextCache.getDeptId() + userContextCache.getDeptName() + userContextCache.getDdId()));
        if (userContextCache.getDeptId() == null) {
            param.getParams().put("userName", new Parameter("eq", (Object)userContextCache.getUserName()));
        } else if (!userContextCache.getDeptId().equals(1502571152969568257L)) {
            param.getParams().put("deptName", new Parameter("eq", (Object)userContextCache.getDeptName()));
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("today")) {
            String today = (String)((Parameter)param.getParams().get("today")).getValue();
            param.getParams().remove("today");
            param.getParams().put("startTime", new Parameter("le", (Object)today));
            param.getParams().put("endTime", new Parameter("ge", (Object)today));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), LeaveVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryEndList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryEndList(HttpServletRequest request) {
        this.logger.info("\u6d88\u606f\u53d1\u9001\u524d1---------------->");
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, 20);
        String startTime = df1.format(calendar.getTime());
        calendar.add(12, 20);
        String endTime = df1.format(calendar.getTime());
        QueryParam param = new QueryParam();
        param.getParams().put("endTime", new Parameter("between", (Object)(startTime + "," + endTime)));
        List leaveEntities = this.service.queryList(param);
        this.logger.info("\u6d88\u606f\u53d1\u9001\u524d2---------------->");
        for (LeaveEntity taskEntity : leaveEntities) {
            CommonResponse longCommonResponse;
            if (taskEntity.getUserCard() == null || (longCommonResponse = this.shareCategoryApi.queryUserIdByCard(taskEntity.getUserCard())).getCode() != 0) continue;
            this.sendSys(longCommonResponse.getData() + "", (taskEntity.getEndTime().getTime() - new Date().getTime()) / 1000L / 60L, taskEntity.getId());
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/updateEndTime"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<LeaveVO> updateEndTime(@RequestBody LeaveVO saveOrUpdateVO) {
        this.service.updateEndTime(saveOrUpdateVO.getId(), saveOrUpdateVO.getEndTime(), saveOrUpdateVO.getOutTime(), new Date());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)saveOrUpdateVO);
    }

    public boolean sendSys(String receiverId, Long sum, Long id) {
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        channel.add("weixinee");
        channel.add("sys");
        Object[] receivers = new String[]{receiverId};
        parameter.setReceivers((String[])receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType("earlywarning");
        parameter.setSubject("\u60a8\u8ddd\u79bb\u8bf7\u5047\u7ed3\u675f\u65f6\u95f4\u8fd8\u6709" + sum + "\u5206\u949f\uff01");
        parameter.setContent("\u5185\u5bb9");
        parameter.setPcUrl("/zzyj-outputvalcount-frontend/#/userGoOutOa/card?id=" + id);
        parameter.setMobileUrl("/ejc-zzyjapproval-mobile/#/userGoOutOa/card?id=" + id);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        JSONObject weixineeParams = new JSONObject();
        weixineeParams.put("agentid", (Object)PRO_AGENTID);
        weixineeParams.put("secret", (Object)PRO_SECRET);
        weixineeParams.put("msgtype", (Object)"textcard");
        weixineeParams.put("title", (Object)"\u8bf7\u5047\u5373\u5c06\u7ed3\u675f\u901a\u77e5");
        weixineeParams.put("description", (Object)("\u60a8\u8ddd\u79bb\u8bf7\u5047\u7ed3\u675f\u65f6\u95f4\u8fd8\u6709" + sum + "\u5206\u949f\uff01"));
        weixineeParams.put("url", (Object)("https://pms.zzyjjt.com/portal/sso/index?&userid=" + receiverId + "&targeturl=https%3A%2F%2Fpms.zzyjjt.com%2Fejc-zzyjapproval-mobile%2F%23%2FuserGoOutOa%2Fcard%3Fid%3D" + id + "%26userid%3D" + receiverId));
        weixineeParams.put("btntxt", (Object)"\u70b9\u51fb\u67e5\u770b");
        parameter.setWeixineeParams(weixineeParams);
        CommonResponse result = this.pushMessageApi.pushMessage(parameter);
        if (result.isSuccess()) {
            this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->,\u63a5\u6536\u4eba:{}," + result.getMsg(), (Object)Arrays.toString(receivers));
            return true;
        }
        this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
        return false;
    }
}

