/*
 * Decompiled with CFR 0.152.
 */
package com.examstack.portal.controller.action;

import com.examstack.common.domain.exam.AnswerSheet;
import com.examstack.common.domain.exam.Exam;
import com.examstack.common.domain.exam.ExamHistory;
import com.examstack.common.domain.exam.Message;
import com.examstack.portal.security.UserInfo;
import com.examstack.portal.service.ExamService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.io.IOException;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ExamAction {
    @Autowired
    private ExamService examService;
    @Autowired
    private AmqpTemplate qmqpTemplate;

    @RequestMapping(value={"student/get-answersheet/{histId}"}, method={RequestMethod.GET})
    @ResponseBody
    public AnswerSheet getAnswerSheet(@PathVariable(value="histId") int histId) {
        ExamHistory history = this.examService.getUserExamHistListByHistId(histId);
        Gson gson = new Gson();
        AnswerSheet answerSheet = (AnswerSheet)gson.fromJson(history.getAnswerSheet(), AnswerSheet.class);
        return answerSheet;
    }

    @RequestMapping(value={"student/exam/send-apply/{examId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Message sendApply(@PathVariable(value="examId") int examId) {
        Message msg = new Message();
        UserInfo userInfo = (UserInfo)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        try {
            Exam exam = this.checkExam(examId);
            this.examService.addUserExamHist(userInfo.getUserid(), examId, exam.getExamPaperId(), 0);
        }
        catch (Exception e) {
            msg.setResult(e.getMessage());
            e.printStackTrace();
        }
        return msg;
    }

    public Exam checkExam(int examId) throws Exception {
        Exam exam = this.examService.getExamById(examId);
        if (exam == null) {
            throw new Exception("\u8003\u8bd5\u4e0d\u5b58\u5728\uff01\u6216\u5df2\u7ecf\u7533\u8bf7\u8fc7\u4e00\u6b21\uff01");
        }
        if (exam.getApproved() != 1) {
            throw new Exception("\u4e0d\u80fd\u7533\u8bf7\u4e00\u4e2a\u672a\u5ba1\u6838\u901a\u8fc7\u7684\u8003\u8bd5\uff01");
        }
        return exam;
    }

    @RequestMapping(value={"/student/exam-submit"}, method={RequestMethod.POST})
    @ResponseBody
    public Message finishExam(@RequestBody AnswerSheet answerSheet) {
        Message message = new Message();
        ObjectMapper om = new ObjectMapper();
        try {
            this.qmqpTemplate.convertAndSend("examplus.answersheetToScoreMaker", (Object)om.writeValueAsBytes((Object)answerSheet));
        }
        catch (AmqpException e) {
            e.printStackTrace();
            message.setResult("\u4ea4\u5377\u5931\u8d25");
            message.setMessageInfo(e.toString());
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            message.setResult("\u4ea4\u5377\u5931\u8d25");
            message.setMessageInfo(e.toString());
        }
        return message;
    }

    @RequestMapping(value={"addAnswerSheet4Test"}, method={RequestMethod.GET})
    @ResponseBody
    public Message addAnswerSheet4Test(Model model) throws org.codehaus.jackson.JsonProcessingException, IOException {
        Message msg = new Message();
        AnswerSheet as = new AnswerSheet();
        as.setExamPaperId(2);
        ObjectMapper om = new ObjectMapper();
        this.qmqpTemplate.convertAndSend("examplus.answersheetToScoreMaker", (Object)om.writeValueAsBytes((Object)as));
        return msg;
    }
}

