/*
 * Decompiled with CFR 0.152.
 */
package com.examstack.portal.controller.action;

import com.examstack.common.domain.exam.Message;
import com.examstack.common.domain.user.User;
import com.examstack.common.util.StandardPasswordEncoderForSha1;
import com.examstack.portal.security.UserInfo;
import com.examstack.portal.service.UserService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class UserAction {
    @Autowired
    private UserService userService;

    @RequestMapping(value={"/add-user"}, method={RequestMethod.POST})
    @ResponseBody
    public Message addUser(@RequestBody User user) {
        user.setCreateTime(new Date());
        String password = user.getPassword() + "{" + user.getUserName().toLowerCase() + "}";
        StandardPasswordEncoderForSha1 passwordEncoder = new StandardPasswordEncoderForSha1();
        String resultPassword = passwordEncoder.encode((CharSequence)password);
        user.setPassword(resultPassword);
        user.setEnabled(true);
        user.setCreateBy(-1);
        user.setUserName(user.getUserName().toLowerCase());
        Message message = new Message();
        try {
            this.userService.addUser(user, "ROLE_STUDENT", 0, this.userService.getRoleMap());
        }
        catch (Exception e) {
            if (e.getMessage().contains(user.getUserName())) {
                message.setResult("duplicate-username");
                message.setMessageInfo("\u91cd\u590d\u7684\u7528\u6237\u540d");
            }
            if (e.getMessage().contains(user.getNationalId())) {
                message.setResult("duplicate-national-id");
                message.setMessageInfo("\u91cd\u590d\u7684\u8eab\u4efd\u8bc1");
            }
            if (e.getMessage().contains(user.getEmail())) {
                message.setResult("duplicate-email");
                message.setMessageInfo("\u91cd\u590d\u7684\u90ae\u7bb1");
            }
            if (e.getMessage().contains(user.getPhoneNum())) {
                message.setResult("duplicate-phone");
                message.setMessageInfo("\u91cd\u590d\u7684\u7535\u8bdd");
            }
            message.setResult(e.getCause().getMessage());
            e.printStackTrace();
        }
        return message;
    }

    @RequestMapping(value={"/student/update-user"}, method={RequestMethod.POST})
    @ResponseBody
    public Message updateUser(@RequestBody User user) {
        UserInfo userInfo = (UserInfo)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String password = user.getPassword() + "{" + user.getUserName() + "}";
        StandardPasswordEncoderForSha1 passwordEncoder = new StandardPasswordEncoderForSha1();
        String resultPassword = "";
        if (user.getPassword() != null) {
            resultPassword = "".equals(user.getPassword().trim()) ? "" : passwordEncoder.encode((CharSequence)password);
        }
        user.setPassword(resultPassword);
        user.setEnabled(true);
        Message message = new Message();
        try {
            this.userService.updateUser(user, null);
            userInfo.setTrueName(user.getTrueName());
            userInfo.setEmail(user.getEmail());
            userInfo.setNationalId(user.getNationalId());
            userInfo.setPhoneNum(user.getPhoneNum());
        }
        catch (Exception e) {
            if (e.getMessage().contains(user.getUserName())) {
                message.setResult("duplicate-username");
                message.setMessageInfo("\u91cd\u590d\u7684\u7528\u6237\u540d");
            }
            if (e.getMessage().contains(user.getNationalId())) {
                message.setResult("duplicate-national-id");
                message.setMessageInfo("\u91cd\u590d\u7684\u8eab\u4efd\u8bc1");
            }
            if (e.getMessage().contains(user.getEmail())) {
                message.setResult("duplicate-email");
                message.setMessageInfo("\u91cd\u590d\u7684\u90ae\u7bb1");
            }
            if (e.getMessage().contains(user.getPhoneNum())) {
                message.setResult("duplicate-phone");
                message.setMessageInfo("\u91cd\u590d\u7684\u7535\u8bdd");
            }
            message.setResult(e.getCause().getMessage());
            e.printStackTrace();
        }
        return message;
    }

    @RequestMapping(value={"/student/change-pwd"}, method={RequestMethod.POST})
    @ResponseBody
    public Message changePassword(@RequestBody User user) {
        Message message = new Message();
        UserInfo userInfo = (UserInfo)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        try {
            String password = user.getPassword() + "{" + userInfo.getUsername() + "}";
            StandardPasswordEncoderForSha1 passwordEncoder = new StandardPasswordEncoderForSha1();
            String resultPassword = passwordEncoder.encode((CharSequence)password);
            user.setPassword(resultPassword);
            user.setUserName(userInfo.getUsername());
            this.userService.updateUserPwd(user, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            message.setResult(e.getClass().getName());
        }
        return message;
    }
}

