/*
 * Decompiled with CFR 0.152.
 */
package com.examstack.portal.controller.page;

import com.examstack.common.domain.exam.AnswerSheet;
import com.examstack.common.domain.exam.AnswerSheetItem;
import com.examstack.common.domain.exam.Exam;
import com.examstack.common.domain.exam.ExamHistory;
import com.examstack.common.domain.exam.ExamPaper;
import com.examstack.common.domain.question.KnowledgePoint;
import com.examstack.common.domain.question.QuestionQueryResult;
import com.examstack.common.domain.question.QuestionStatistic;
import com.examstack.common.util.Page;
import com.examstack.common.util.QuestionAdapter;
import com.examstack.portal.security.UserInfo;
import com.examstack.portal.service.ExamPaperService;
import com.examstack.portal.service.ExamService;
import com.examstack.portal.service.QuestionHistoryService;
import com.examstack.portal.service.QuestionService;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class ExamPage {
    @Autowired
    private ExamService examService;
    @Autowired
    private ExamPaperService examPaperService;
    @Autowired
    private QuestionHistoryService questionHistoryService;
    @Autowired
    private QuestionService questionService;

    @RequestMapping(value={"/exam-list"}, method={RequestMethod.GET})
    public String examListPage(Model model, HttpServletRequest request) {
        int userId = 0;
        if (SecurityContextHolder.getContext().getAuthentication() != null && !SecurityContextHolder.getContext().getAuthentication().getPrincipal().toString().endsWith("anonymousUser")) {
            UserInfo userInfo = (UserInfo)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            userId = userInfo.getUserid();
        }
        Page page = new Page();
        page.setPageSize(10);
        page.setPageNo(1);
        List examListToApply = this.examService.getExamListToApply(userId, page);
        List examListToStart = this.examService.getExamListToStart(userId, null, new int[]{1, 2});
        List modelTestToStart = this.examService.getExamList(null, new int[]{3});
        model.addAttribute("examListToApply", (Object)examListToApply);
        model.addAttribute("examListToStart", (Object)examListToStart);
        model.addAttribute("modelTestToStart", (Object)modelTestToStart);
        model.addAttribute("userId", (Object)userId);
        return "exam";
    }

    @RequestMapping(value={"/student/exam-start/{examId}"}, method={RequestMethod.GET})
    public String examStartPage(Model model, HttpServletRequest request, @PathVariable(value="examId") int examId) {
        UserInfo userInfo = (UserInfo)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String strUrl = "http://" + request.getServerName() + ":" + request.getServerPort() + "/";
        int duration = 0;
        Exam exam = this.examService.getExamById(examId);
        if (exam.getApproved() != 1 || exam.getExpTime().before(new Date()) || exam.getExamType() == 3) {
            model.addAttribute("errorMsg", (Object)"\u8003\u8bd5\u672a\u5ba1\u6838\u6216\u5f53\u524d\u65f6\u95f4\u4e0d\u80fd\u8003\u8bd5\u6216\u8003\u8bd5\u7c7b\u578b\u9519\u8bef");
            return "error";
        }
        ExamHistory examHistory = this.examService.getUserExamHistByUserIdAndExamId(userInfo.getUserid(), examId, new int[]{0, 1, 2, 3});
        Date startTime = examHistory.getStartTime() == null ? new Date() : examHistory.getStartTime();
        switch (examHistory.getApproved()) {
            case 0: {
                model.addAttribute("errorMsg", (Object)"\u8003\u8bd5\u672a\u5ba1\u6838");
                return "error";
            }
            case 2: {
                model.addAttribute("errorMsg", (Object)"\u5df2\u4ea4\u5377\uff0c\u4e0d\u80fd\u91cd\u590d\u8003\u8bd5");
                return "error";
            }
            case 3: {
                model.addAttribute("errorMsg", (Object)"\u5df2\u9605\u5377\uff0c\u4e0d\u80fd\u91cd\u590d\u8003\u8bd5");
                return "error";
            }
        }
        ExamPaper examPaper = this.examPaperService.getExamPaperById(examHistory.getExamPaperId());
        String content = examPaper.getContent();
        Gson gson = new Gson();
        duration = examPaper.getDuration();
        List questionList = (List)gson.fromJson(content, new /* Unavailable Anonymous Inner Class!! */.getType());
        StringBuilder sb = new StringBuilder();
        for (QuestionQueryResult question : questionList) {
            QuestionAdapter adapter = new QuestionAdapter(question, strUrl);
            sb.append(adapter.getUserExamPaper());
        }
        model.addAttribute("startTime", (Object)startTime);
        model.addAttribute("examHistoryId", (Object)examHistory.getHistId());
        model.addAttribute("examId", (Object)examHistory.getExamId());
        model.addAttribute("examPaperId", (Object)examHistory.getExamPaperId());
        model.addAttribute("duration", (Object)(duration * 60));
        model.addAttribute("htmlStr", (Object)sb.toString());
        userInfo.setHistId(0);
        return "examing";
    }

    @RequestMapping(value={"/student/model-test-start/{examId}"}, method={RequestMethod.GET})
    public String modelTestStartPage(Model model, HttpServletRequest request, @PathVariable(value="examId") int examId) {
        UserInfo userInfo = (UserInfo)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String strUrl = "http://" + request.getServerName() + ":" + request.getServerPort() + "/";
        int duration = 0;
        Exam exam = this.examService.getExamById(examId);
        if (exam.getApproved() != 1 || exam.getExpTime().before(new Date()) || exam.getExamType() != 3) {
            model.addAttribute("errorMsg", (Object)"\u8003\u8bd5\u672a\u5ba1\u6838\u6216\u5f53\u524d\u65f6\u95f4\u4e0d\u80fd\u8003\u8bd5\u6216\u8003\u8bd5\u7c7b\u578b\u9519\u8bef");
            return "error";
        }
        ExamPaper examPaper = this.examPaperService.getExamPaperById(exam.getExamPaperId());
        ExamHistory examHistory = this.examService.getUserExamHistByUserIdAndExamId(userInfo.getUserid(), examId, new int[]{0, 1, 2, 3});
        int historyId = 0;
        historyId = examHistory == null ? this.examService.addUserExamHist(userInfo.getUserid(), examId, examPaper.getId(), 1) : examHistory.getHistId();
        String content = examPaper.getContent();
        Gson gson = new Gson();
        duration = examPaper.getDuration();
        List questionList = (List)gson.fromJson(content, new /* Unavailable Anonymous Inner Class!! */.getType());
        StringBuilder sb = new StringBuilder();
        for (QuestionQueryResult question : questionList) {
            QuestionAdapter adapter = new QuestionAdapter(question, strUrl);
            sb.append(adapter.getUserExamPaper());
        }
        model.addAttribute("examHistoryId", (Object)historyId);
        model.addAttribute("examId", (Object)examId);
        model.addAttribute("examPaperId", (Object)examPaper.getId());
        model.addAttribute("duration", (Object)(duration * 60));
        model.addAttribute("htmlStr", (Object)sb.toString());
        userInfo.setHistId(0);
        return "examing";
    }

    @RequestMapping(value={"/student/student-answer-sheet/{examId}"}, method={RequestMethod.GET})
    private String studentAnswerSheetPage(Model model, HttpServletRequest request, @PathVariable int examId) {
        UserInfo userInfo = (UserInfo)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        ExamHistory history = this.examService.getUserExamHistByUserIdAndExamId(userInfo.getUserid(), examId, new int[]{2, 3});
        int examPaperId = history.getExamPaperId();
        String strUrl = "http://" + request.getServerName() + ":" + request.getServerPort() + "/";
        ExamPaper examPaper = this.examPaperService.getExamPaperById(examPaperId);
        StringBuilder sb = new StringBuilder();
        if (examPaper.getContent() != null && !examPaper.getContent().equals("")) {
            Gson gson = new Gson();
            String content = examPaper.getContent();
            List questionList = (List)gson.fromJson(content, new /* Unavailable Anonymous Inner Class!! */.getType());
            for (QuestionQueryResult question : questionList) {
                QuestionAdapter adapter = new QuestionAdapter(question, strUrl);
                sb.append(adapter.getStringFromXML());
            }
        }
        model.addAttribute("htmlStr", (Object)sb);
        model.addAttribute("exampaperid", (Object)examPaperId);
        model.addAttribute("examHistoryId", (Object)history.getHistId());
        model.addAttribute("exampapername", (Object)examPaper.getName());
        model.addAttribute("examId", (Object)history.getExamId());
        return "student-answer-sheet";
    }

    @RequestMapping(value={"student/finish-exam/{examId}"}, method={RequestMethod.GET})
    public String examFinishedPage(Model model, @PathVariable(value="examId") int examId) {
        UserInfo userInfo = (UserInfo)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        ExamHistory history = this.examService.getUserExamHistByUserIdAndExamId(userInfo.getUserid(), examId, new int[]{2, 3});
        Gson gson = new Gson();
        List questionList = (List)gson.fromJson(history.getContent(), new /* Unavailable Anonymous Inner Class!! */.getType());
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (QuestionQueryResult q : questionList) {
            idList.add(q.getQuestionId());
        }
        AnswerSheet as = (AnswerSheet)gson.fromJson(history.getAnswerSheet(), AnswerSheet.class);
        HashMap<Integer, AnswerSheetItem> hm = new HashMap<Integer, AnswerSheetItem>();
        for (AnswerSheetItem item : as.getAnswerSheetItems()) {
            hm.put(item.getQuestionId(), item);
        }
        int total = questionList.size();
        int wrong = 0;
        int right = 0;
        HashMap<Integer, QuestionStatistic> reportResultMap = new HashMap<Integer, QuestionStatistic>();
        List questionQueryList = this.questionService.getQuestionAnalysisListByIdList(idList);
        Map pointMap = this.questionService.getKnowledgePointByFieldId(null, new int[0]);
        HashMap<Integer, Boolean> answer = new HashMap<Integer, Boolean>();
        for (QuestionQueryResult result : questionQueryList) {
            QuestionStatistic statistic = (QuestionStatistic)reportResultMap.get(result.getKnowledgePointId());
            if (statistic == null) {
                statistic = new QuestionStatistic();
            }
            statistic.setPointId(result.getKnowledgePointId());
            statistic.setPointName(((KnowledgePoint)pointMap.get(result.getKnowledgePointId())).getPointName());
            statistic.setAmount(statistic.getAmount() + 1);
            if (((AnswerSheetItem)hm.get(result.getQuestionId())).isRight()) {
                statistic.setRightAmount(statistic.getRightAmount() + 1);
                ++right;
                answer.put(result.getQuestionId(), true);
            } else {
                statistic.setWrongAmount(statistic.getWrongAmount() + 1);
                ++wrong;
                answer.put(result.getQuestionId(), false);
            }
            ++total;
            reportResultMap.put(result.getKnowledgePointId(), statistic);
        }
        model.addAttribute("total", (Object)total);
        model.addAttribute("wrong", (Object)wrong);
        model.addAttribute("right", (Object)right);
        model.addAttribute("reportResultMap", reportResultMap);
        model.addAttribute("create_time", (Object)history.getCreateTime());
        model.addAttribute("answer", answer);
        model.addAttribute("idList", idList);
        return "exam-finished";
    }

    @RequestMapping(value={"student/finished-submit"}, method={RequestMethod.GET})
    public String finishedSubmitPage(Model model) {
        return "finished-submit";
    }
}

