/*
 * Decompiled with CFR 0.152.
 */
package com.examstack.portal.controller.page;

import com.examstack.common.domain.exam.UserQuestionHistory;
import com.examstack.common.domain.practice.KnowledgePointAnalysisResult;
import com.examstack.common.domain.practice.TypeAnalysis;
import com.examstack.common.domain.question.Field;
import com.examstack.common.domain.question.QuestionQueryResult;
import com.examstack.common.domain.question.QuestionStatistic;
import com.examstack.common.domain.question.QuestionType;
import com.examstack.common.util.QuestionAdapter;
import com.examstack.portal.security.UserInfo;
import com.examstack.portal.service.QuestionHistoryService;
import com.examstack.portal.service.QuestionService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PracticePage {
    @Autowired
    private QuestionService questionService;
    @Autowired
    private QuestionHistoryService questionHistoryService;

    @RequestMapping(value={"/student/practice-improve/{fieldId}/{knowledgePointId}/{questionTypeId}"}, method={RequestMethod.GET})
    public String practiceImprove(Model model, HttpServletRequest request, @PathVariable(value="fieldId") int fieldId, @PathVariable(value="knowledgePointId") int knowledgePointId, @PathVariable(value="questionTypeId") int questionTypeId) {
        String strUrl = "http://" + request.getServerName() + ":" + request.getServerPort() + "/";
        List qqrList = this.questionService.getQuestionAnalysisListByPointIdAndTypeId(questionTypeId, knowledgePointId);
        String questionTypeName = "";
        String fieldName = "";
        try {
            fieldName = ((QuestionQueryResult)qqrList.get(0)).getPointName().split(">")[1];
        }
        catch (Exception exception) {
            // empty catch block
        }
        Map questionTypeMap = this.questionService.getQuestionTypeMap();
        for (Map.Entry entry : questionTypeMap.entrySet()) {
            if ((Integer)entry.getKey() != questionTypeId) continue;
            questionTypeName = ((QuestionType)entry.getValue()).getName();
            break;
        }
        int amount = qqrList.size();
        StringBuilder sb = new StringBuilder();
        for (QuestionQueryResult qqr : qqrList) {
            QuestionAdapter adapter = new QuestionAdapter(qqr, strUrl);
            sb.append(adapter.getStringFromXML());
        }
        model.addAttribute("questionStr", (Object)sb.toString());
        model.addAttribute("amount", (Object)amount);
        model.addAttribute("fieldName", (Object)fieldName);
        model.addAttribute("questionTypeName", (Object)questionTypeName);
        model.addAttribute("practiceName", (Object)"\u5f3a\u5316\u7ec3\u4e60");
        model.addAttribute("knowledgePointId", (Object)knowledgePointId);
        model.addAttribute("questionTypeId", (Object)questionTypeId);
        model.addAttribute("fieldId", (Object)fieldId);
        return "practice-improve-qh";
    }

    @RequestMapping(value={"/student/practice-incorrect/{fieldId}/{knowledgePointId}"}, method={RequestMethod.GET})
    public String practiceIncorrectQuestions(Model model, HttpServletRequest request, @PathVariable(value="fieldId") int fieldId, @PathVariable(value="knowledgePointId") int knowledgePointId) {
        String strUrl = "http://" + request.getServerName() + ":" + request.getServerPort() + "/";
        UserInfo userInfo = (UserInfo)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        Map historyMap = this.questionHistoryService.getUserQuestionHist(userInfo.getUserid(), fieldId);
        List historyList = (List)historyMap.get(knowledgePointId);
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (UserQuestionHistory history : historyList) {
            if (history.isRight()) continue;
            idList.add(history.getQuestionId());
        }
        List qqrList = new ArrayList();
        if (idList.size() > 0) {
            qqrList = this.questionService.getQuestionAnalysisListByIdList(idList);
        }
        int amount = idList.size();
        StringBuilder sb = new StringBuilder();
        for (QuestionQueryResult qqr : qqrList) {
            QuestionAdapter adapter = new QuestionAdapter(qqr, strUrl);
            sb.append(adapter.getStringFromXML());
        }
        model.addAttribute("questionStr", (Object)sb.toString());
        model.addAttribute("amount", (Object)amount);
        model.addAttribute("questionTypeName", (Object)"\u9519\u9898\u5e93");
        model.addAttribute("practiceName", (Object)"\u9519\u9898\u7ec3\u4e60");
        return "practice-improve";
    }

    @RequestMapping(value={"/student/practice-improve-his/{fieldId}/{knowledgePointId}/{questionTypeId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Integer> getFinishedQuestionId(Model model, HttpServletRequest request, @PathVariable(value="fieldId") int fieldId, @PathVariable(value="knowledgePointId") int knowledgePointId, @PathVariable(value="questionTypeId") int questionTypeId) {
        UserInfo userInfo = (UserInfo)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        Map historyMap = this.questionHistoryService.getUserQuestionHist(userInfo.getUserid(), fieldId);
        ArrayList<Integer> l = new ArrayList<Integer>();
        return l;
    }

    @RequestMapping(value={"/student/practice-test/{fieldId}"}, method={RequestMethod.GET})
    public String practiceStartNew(Model model, HttpServletRequest request, @PathVariable(value="fieldId") int fieldId) {
        String strUrl = "http://" + request.getServerName() + ":" + request.getServerPort() + "/";
        Map map = this.questionService.getQuestionMapByFieldId(fieldId, null);
        ArrayList qqrList = new ArrayList();
        for (Map.Entry entry : map.entrySet()) {
            if (((Map)entry.getValue()).containsKey(1)) {
                qqrList.addAll((Collection)((Map)entry.getValue()).get(1));
            }
            if (((Map)entry.getValue()).containsKey(2)) {
                qqrList.addAll((Collection)((Map)entry.getValue()).get(2));
            }
            if (!((Map)entry.getValue()).containsKey(3)) continue;
            qqrList.addAll((Collection)((Map)entry.getValue()).get(3));
        }
        int amount = 0;
        if (qqrList.size() == 0) {
            model.addAttribute("errorMsg", (Object)"\u65e0\u53ef\u7528\u7684\u9898\u76ee");
            return "error";
        }
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < 20; ++i) {
            int questionCount = qqrList.size();
            int index = random.nextInt(questionCount);
            QuestionAdapter adapter = new QuestionAdapter((QuestionQueryResult)qqrList.get(index), strUrl);
            sb.append(adapter.getStringFromXML());
            qqrList.remove(index);
            ++amount;
            if (qqrList.size() == 0) break;
        }
        model.addAttribute("questionStr", (Object)sb.toString());
        model.addAttribute("amount", (Object)amount);
        model.addAttribute("questionTypeName", (Object)"\u968f\u673a\u9898");
        model.addAttribute("practiceName", (Object)"\u968f\u673a\u7ec3\u4e60");
        return "practice-improve";
    }

    @RequestMapping(value={"/student/practice-list"}, method={RequestMethod.GET})
    public String practiceListPage(Model model, HttpServletRequest request, @RequestParam(value="fieldId", required=false, defaultValue="0") int fieldId) {
        UserInfo userInfo = (UserInfo)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        List fieldList = this.questionService.getAllField(null);
        if (fieldId == 0) {
            fieldId = ((Field)fieldList.get(0)).getFieldId();
        }
        Map questionMap = this.questionService.getTypeQuestionStaticByFieldId(fieldId);
        Map historyMap = this.questionHistoryService.getTypeQuestionHistStaticByFieldId(fieldId, userInfo.getUserid());
        Map historyStatisticMap = this.questionHistoryService.getQuestionHistStaticByFieldId(fieldId, userInfo.getUserid());
        Map pointMap = this.questionService.getKnowledgePointByFieldId(null, new int[]{fieldId});
        ArrayList<KnowledgePointAnalysisResult> kparl = new ArrayList<KnowledgePointAnalysisResult>();
        for (Map.Entry entry : questionMap.entrySet()) {
            KnowledgePointAnalysisResult kpar = new KnowledgePointAnalysisResult();
            kpar.setKnowledgePointId(((Integer)entry.getKey()).intValue());
            ArrayList<TypeAnalysis> tal = new ArrayList<TypeAnalysis>();
            int totalRightAmount = 0;
            int totalAmount = 0;
            for (Map.Entry entry1 : ((Map)entry.getValue()).entrySet()) {
                TypeAnalysis ta = new TypeAnalysis();
                ta.setQuestionTypeId(((Integer)entry1.getKey()).intValue());
                ta.setQuestionTypeName(((QuestionStatistic)entry1.getValue()).getQuestionTypeName());
                int rightAmount = 0;
                int wrongAmount = 0;
                try {
                    rightAmount = ((QuestionStatistic)((Map)historyMap.get(entry.getKey())).get(entry1.getKey())).getRightAmount();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    wrongAmount = ((QuestionStatistic)((Map)historyMap.get(entry.getKey())).get(entry1.getKey())).getWrongAmount();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ta.setRightAmount(rightAmount);
                ta.setWrongAmount(wrongAmount);
                ta.setRestAmount(((QuestionStatistic)entry1.getValue()).getAmount() - rightAmount - wrongAmount);
                tal.add(ta);
                if (kpar.getKnowledgePointName() == null) {
                    kpar.setKnowledgePointName(((QuestionStatistic)entry1.getValue()).getPointName());
                }
                totalRightAmount += rightAmount;
                totalAmount += ((QuestionStatistic)entry1.getValue()).getAmount();
            }
            kpar.setTypeAnalysis(tal);
            if (totalAmount > 0) {
                kpar.setFinishRate((float)totalRightAmount / (float)totalAmount);
            }
            kparl.add(kpar);
        }
        model.addAttribute("kparl", kparl);
        model.addAttribute("fieldId", (Object)fieldId);
        model.addAttribute("historyMap", (Object)historyStatisticMap);
        model.addAttribute("pointMap", (Object)pointMap);
        model.addAttribute("fieldList", (Object)fieldList);
        return "practice";
    }
}

