/*
 * Decompiled with CFR 0.152.
 */
package com.examstack.portal.controller.page;

import com.examstack.common.domain.training.TrainingSection;
import com.examstack.common.domain.training.UserTrainingHistory;
import com.examstack.common.util.Page;
import com.examstack.common.util.PagingUtil;
import com.examstack.portal.security.UserInfo;
import com.examstack.portal.service.TrainingService;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class TrainingPage {
    @Autowired
    private TrainingService trainingService;

    @RequestMapping(value={"/training-list"}, method={RequestMethod.GET})
    public String trainingListPage(Model model, HttpServletRequest request, @RequestParam(value="page", required=false, defaultValue="1") int page) {
        Page pageModel = new Page();
        pageModel.setPageNo(page);
        pageModel.setPageSize(10);
        List trainingList = this.trainingService.getTrainingList(pageModel);
        String pageStr = PagingUtil.getPageBtnlink((int)page, (int)pageModel.getTotalPage());
        model.addAttribute("trainingList", (Object)trainingList);
        model.addAttribute("pageStr", (Object)pageStr);
        return "training-list";
    }

    @RequestMapping(value={"/student/training/{trainingId}"}, method={RequestMethod.GET})
    public String trainingPage(Model model, HttpServletRequest request, @PathVariable(value="trainingId") int trainingId, @RequestParam(value="sectionId", required=false, defaultValue="-1") int sectionId) {
        UserInfo userInfo = (UserInfo)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        List sectionList = this.trainingService.getTrainingSectionByTrainingId(trainingId, null);
        if (sectionList == null) {
            model.addAttribute("errorMsg", (Object)"\u7ae0\u8282\u4e0d\u5b58\u5728\uff01");
            return "error";
        }
        TrainingSection thisSection = null;
        for (TrainingSection section : sectionList) {
            if (section.getSectionId() != sectionId && sectionId != -1) continue;
            String filePath = section.getFilePath();
            section.setFilePath("../" + filePath.replace("\\", "/"));
            thisSection = section;
            sectionId = section.getSectionId();
            break;
        }
        UserTrainingHistory history = this.trainingService.getTrainingHistBySectionId(thisSection.getSectionId(), userInfo.getUserid());
        float duration = 0.0f;
        boolean finished = false;
        if (history != null) {
            duration = history.getDuration();
            if (history.getProcess() == 1.0f) {
                finished = true;
            }
        }
        model.addAttribute("finished", (Object)finished);
        model.addAttribute("duration", (Object)Float.valueOf(duration));
        model.addAttribute("sectionList", (Object)sectionList);
        model.addAttribute("sectionId", (Object)sectionId);
        model.addAttribute("section", (Object)thisSection);
        if (thisSection.getFileType().toLowerCase().equals(".pdf")) {
            return "training-pdf";
        }
        return "training";
    }

    @RequestMapping(value={"/student/training/video"}, method={RequestMethod.GET})
    public String videoPage(Model model, HttpServletRequest request) {
        return "video";
    }

    @RequestMapping(value={"/student/training-history"}, method={RequestMethod.GET})
    public String trainingHistory(Model model, HttpServletRequest request, @RequestParam(value="page", required=false, defaultValue="1") int page) {
        UserInfo userInfo = (UserInfo)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        Page pageModel = new Page();
        pageModel.setPageNo(page);
        pageModel.setPageSize(10);
        List trainingList = this.trainingService.getTrainingList(pageModel);
        Map processMap = this.trainingService.getTrainingSectionProcessMapByUserId(userInfo.getUserid());
        String pageStr = PagingUtil.getPageBtnlink((int)page, (int)pageModel.getTotalPage());
        model.addAttribute("trainingList", (Object)trainingList);
        model.addAttribute("processMap", (Object)processMap);
        model.addAttribute("pageStr", (Object)pageStr);
        return "training-history";
    }
}

