/*
 * Decompiled with CFR 0.152.
 */
package com.examstack.portal.controller.page;

import com.examstack.common.domain.practice.KnowledgePointAnalysisResult;
import com.examstack.common.domain.practice.TypeAnalysis;
import com.examstack.common.domain.question.Field;
import com.examstack.common.domain.question.QuestionStatistic;
import com.examstack.common.util.Page;
import com.examstack.common.util.PagingUtil;
import com.examstack.portal.controller.page.UserCenterPage;
import com.examstack.portal.security.UserInfo;
import com.examstack.portal.service.ExamService;
import com.examstack.portal.service.QuestionHistoryService;
import com.examstack.portal.service.QuestionService;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class UserCenterPage {
    @Autowired
    private QuestionService questionService;
    @Autowired
    private QuestionHistoryService questionHistoryService;
    @Autowired
    private ExamService examService;

    @RequestMapping(value={"student/usercenter"}, method={RequestMethod.GET})
    public String userCenterDefaultPage(Model model, HttpServletRequest request) {
        List fieldList = this.questionService.getAllField(null);
        return "redirect:/student/usercenter/" + ((Field)fieldList.get(0)).getFieldId();
    }

    @RequestMapping(value={"student/usercenter/{fieldId}"}, method={RequestMethod.GET})
    public String userCenterPage(Model model, HttpServletRequest request, @PathVariable int fieldId) {
        UserInfo userInfo = (UserInfo)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        model.addAttribute("username", (Object)userInfo.getUsername());
        model.addAttribute("username", (Object)userInfo.getTrueName());
        model.addAttribute("email", (Object)userInfo.getEmail());
        model.addAttribute("field", (Object)userInfo.getFieldName());
        Map questionStatisticMap = this.questionService.getQuestionStaticByFieldId(fieldId);
        Map questionHistStatisticMap = this.questionHistoryService.getQuestionHistStaticByFieldId(fieldId, userInfo.getUserid());
        model.addAttribute("lastLoginTime", (Object)userInfo.getLastLoginTime());
        ArrayList<StatisticsResult> resultList = new ArrayList<StatisticsResult>();
        ArrayList<Label> titleList = new ArrayList<Label>();
        ArrayList<Float> finishRateList = new ArrayList<Float>();
        ArrayList<Float> rightRateList = new ArrayList<Float>();
        for (Map.Entry entry : questionStatisticMap.entrySet()) {
            StatisticsResult sr = new StatisticsResult(this);
            sr.setPointId(((QuestionStatistic)entry.getValue()).getPointId());
            sr.setPointName(((QuestionStatistic)entry.getValue()).getPointName());
            sr.setAmount(((QuestionStatistic)entry.getValue()).getAmount());
            if (questionHistStatisticMap.containsKey(entry.getKey())) {
                int rightAmount = ((QuestionStatistic)questionHistStatisticMap.get(entry.getKey())).getRightAmount();
                int wrongAmount = ((QuestionStatistic)questionHistStatisticMap.get(entry.getKey())).getWrongAmount();
                int amount = ((QuestionStatistic)questionHistStatisticMap.get(entry.getKey())).getAmount();
                sr.setRightTimes(rightAmount);
                sr.setWrongTimes(wrongAmount);
                sr.setFinishRate((float)amount / (float)((QuestionStatistic)entry.getValue()).getAmount());
                sr.setRightRate(amount == 0 ? 0.0f : (float)rightAmount / (float)amount);
                finishRateList.add(Float.valueOf(sr.getFinishRate()));
                rightRateList.add(Float.valueOf(sr.getRightRate()));
            } else {
                finishRateList.add(Float.valueOf(0.0f));
                rightRateList.add(Float.valueOf(0.0f));
            }
            resultList.add(sr);
            Label label = new Label(this, sr.getPointName(), 1);
            titleList.add(label);
        }
        Gson gson = new Gson();
        model.addAttribute("sr", resultList);
        model.addAttribute("labels", (Object)gson.toJson(titleList));
        model.addAttribute("finishrate", (Object)gson.toJson(finishRateList));
        model.addAttribute("correctrate", (Object)gson.toJson(rightRateList));
        model.addAttribute("fieldList", (Object)this.questionService.getAllField(null));
        model.addAttribute("fieldId", (Object)fieldId);
        return "usercenter";
    }

    @RequestMapping(value={"student/analysis"}, method={RequestMethod.GET})
    public String userAnalysisDefaultPage(Model model, HttpServletRequest request) {
        List fieldList = this.questionService.getAllField(null);
        return "redirect:/student/analysis/" + ((Field)fieldList.get(0)).getFieldId();
    }

    @RequestMapping(value={"student/analysis/{fieldId}"}, method={RequestMethod.GET})
    public String userAnalysisPage(Model model, HttpServletRequest request, @PathVariable int fieldId) {
        UserInfo userInfo = (UserInfo)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        model.addAttribute("lastLoginTime", (Object)userInfo.getLastLoginTime());
        Map questionMap = this.questionService.getTypeQuestionStaticByFieldId(fieldId);
        Map historyMap = this.questionHistoryService.getTypeQuestionHistStaticByFieldId(fieldId, userInfo.getUserid());
        ArrayList<KnowledgePointAnalysisResult> kparl = new ArrayList<KnowledgePointAnalysisResult>();
        for (Map.Entry entry : questionMap.entrySet()) {
            KnowledgePointAnalysisResult kpar = new KnowledgePointAnalysisResult();
            kpar.setKnowledgePointId(((Integer)entry.getKey()).intValue());
            ArrayList<TypeAnalysis> tal = new ArrayList<TypeAnalysis>();
            int totalRightAmount = 0;
            int totalAmount = 0;
            for (Map.Entry entry1 : ((Map)entry.getValue()).entrySet()) {
                TypeAnalysis ta = new TypeAnalysis();
                ta.setQuestionTypeId(((Integer)entry1.getKey()).intValue());
                ta.setQuestionTypeName(((QuestionStatistic)entry1.getValue()).getQuestionTypeName());
                int rightAmount = 0;
                int wrongAmount = 0;
                try {
                    rightAmount = ((QuestionStatistic)((Map)historyMap.get(entry.getKey())).get(entry1.getKey())).getRightAmount();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    wrongAmount = ((QuestionStatistic)((Map)historyMap.get(entry.getKey())).get(entry1.getKey())).getWrongAmount();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ta.setRightAmount(rightAmount);
                ta.setWrongAmount(wrongAmount);
                ta.setRestAmount(((QuestionStatistic)entry1.getValue()).getAmount() - rightAmount - wrongAmount);
                tal.add(ta);
                if (kpar.getKnowledgePointName() == null) {
                    kpar.setKnowledgePointName(((QuestionStatistic)entry1.getValue()).getPointName());
                }
                totalRightAmount += rightAmount;
                totalAmount += ((QuestionStatistic)entry1.getValue()).getAmount();
            }
            kpar.setTypeAnalysis(tal);
            if (totalAmount > 0) {
                kpar.setFinishRate((float)totalRightAmount / (float)totalAmount);
            }
            kparl.add(kpar);
        }
        model.addAttribute("kparl", kparl);
        model.addAttribute("fieldList", (Object)this.questionService.getAllField(null));
        model.addAttribute("fieldId", (Object)fieldId);
        return "analysis";
    }

    @RequestMapping(value={"student/exam-history"}, method={RequestMethod.GET})
    public String userExamHistPage(Model model, HttpServletRequest request) {
        int index = 1;
        if (request.getParameter("page") != null) {
            index = Integer.parseInt(request.getParameter("page"));
        }
        UserInfo userInfo = (UserInfo)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        Page pageModel = new Page();
        pageModel.setPageNo(index);
        List hisList = this.examService.getUserExamHistByUserId(userInfo.getUserid(), pageModel, new int[]{1, 2, 3});
        model.addAttribute("hisList", (Object)hisList);
        String pageStr = PagingUtil.getPagelink((int)index, (int)pageModel.getTotalPage(), (String)"", (String)"student/exam-history");
        model.addAttribute("pageStr", (Object)pageStr);
        return "exam-history";
    }

    @RequestMapping(value={"/user-detail/{userName}"}, method={RequestMethod.GET})
    public String userInfoPage(Model model, HttpServletRequest request, @PathVariable(value="userName") String userName) {
        return "redirect:/student/usercenter";
    }
}

