/*
 * Decompiled with CFR 0.152.
 */
package com.examstack.portal.controller.page;

import com.examstack.common.domain.news.News;
import com.examstack.common.util.Page;
import com.examstack.portal.security.UserInfo;
import com.examstack.portal.service.ExamService;
import com.examstack.portal.service.NewsService;
import com.examstack.portal.service.QuestionService;
import com.examstack.portal.service.UserService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class UserPage {
    @Autowired
    private UserService userService;
    @Autowired
    private ExamService examService;
    @Autowired
    private QuestionService questionService;
    @Autowired
    private NewsService newsService;

    @RequestMapping(value={"/user-login-page"}, method={RequestMethod.GET})
    public String loginPage(Model model, @RequestParam(value="result", required=false, defaultValue="") String result, HttpServletRequest request) {
        AuthenticationServiceException exception = (AuthenticationServiceException)request.getSession().getAttribute("SPRING_SECURITY_LAST_EXCEPTION");
        if (exception != null && ("\u51c6\u8003\u8bc1\u53f7\u7801\u9519\u8bef\uff01".equals(exception.getMessage()) || "\u4e0d\u5728\u8003\u8bd5\u65f6\u95f4\u8303\u56f4\u5185\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528\u51c6\u8003\u8bc1\uff01".equals(exception.getMessage()))) {
            return "redirect:quick-start";
        }
        return "login";
    }

    @RequestMapping(value={"/quick-start"}, method={RequestMethod.GET})
    public String quickStartPage(Model model, @RequestParam(value="result", required=false, defaultValue="") String result) {
        return "quick-start";
    }

    @RequestMapping(value={"/user-register"}, method={RequestMethod.GET})
    public String registerPage(Model model) {
        List depList = this.userService.getDepList(null);
        model.addAttribute("depList", (Object)depList);
        return "register";
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public String homePage(Model model) {
        return "redirect:home";
    }

    @RequestMapping(value={"home"}, method={RequestMethod.GET})
    public String directToBaseHomePage(Model model, HttpServletRequest request) {
        Page pageModel = new Page();
        pageModel.setPageNo(1);
        pageModel.setPageSize(2);
        List newsList = this.newsService.getNewsList(pageModel);
        model.addAttribute("newsList", (Object)newsList);
        request.getSession().removeAttribute("SPRING_SECURITY_LAST_EXCEPTION");
        String result = request.getParameter("result");
        if ("failed".equals(result)) {
            model.addAttribute("result_msg", (Object)"\u767b\u9646\u5931\u8d25");
        }
        if (SecurityContextHolder.getContext().getAuthentication() == null) {
            return "home";
        }
        if (SecurityContextHolder.getContext().getAuthentication().getPrincipal().toString().endsWith("anonymousUser")) {
            return "home";
        }
        UserInfo userInfo = (UserInfo)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (userInfo.getHistId() != 0) {
            return "redirect:student/exam-start/" + userInfo.getExamId();
        }
        return "home";
    }

    @RequestMapping(value={"student/setting"}, method={RequestMethod.GET})
    public String settingPage(Model model) {
        List depList = this.userService.getDepList(null);
        model.addAttribute("depList", (Object)depList);
        return "setting";
    }

    @RequestMapping(value={"student/change-password"}, method={RequestMethod.GET})
    public String changePasswordPage() {
        return "change-password";
    }

    @RequestMapping(value={"news/{newsId}"}, method={RequestMethod.GET})
    public String newsDetailPage(Model model, @PathVariable(value="newsId") int newsId) {
        News news = this.newsService.getNewsById(newsId);
        model.addAttribute("news", (Object)news);
        return "news-detail";
    }
}

