/*
 * Decompiled with CFR 0.152.
 */
package com.examstack.portal.security.filter;

import com.examstack.common.domain.exam.Exam;
import com.examstack.common.domain.exam.ExamHistory;
import com.examstack.common.util.StandardPasswordEncoderForSha1;
import com.examstack.portal.security.UserInfo;
import com.examstack.portal.service.ExamService;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.util.StringUtils;

public class AuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    public static final String VALIDATE_CODE = "validate_code";
    public static final String USERNAME = "j_username";
    public static final String PASSWORD = "j_password";
    public static final String SERI_NO = "j_seri_no";
    public static final String FLAG = "j_flag";
    private static Logger log = Logger.getLogger(AuthenticationFilter.class);
    @Autowired
    public ExamService examService;

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        String seriNo = this.obtainSeriNoParameter(request);
        String username = this.obtainUsername(request);
        String password = this.obtainPassword(request);
        String flag = this.obtainFlagParameter(request);
        String sh1Password = password + "{" + username + "}";
        StandardPasswordEncoderForSha1 passwordEncoder = new StandardPasswordEncoderForSha1();
        String result = passwordEncoder.encode((CharSequence)sh1Password);
        log.info((Object)result);
        if (!request.getMethod().equals("POST")) {
            throw new AuthenticationServiceException("Authentication method not supported: " + request.getMethod());
        }
        if (seriNo != null && !"".equals(seriNo)) {
            ExamHistory hist = this.examService.getUserExamHistBySeriNo(seriNo, 1);
            if (hist == null) {
                throw new AuthenticationServiceException("\u51c6\u8003\u8bc1\u53f7\u7801\u9519\u8bef\uff01");
            }
            username = hist.getUserName();
            password = "";
            Exam exam = this.examService.getExamById(hist.getExamId());
            if (exam.getApproved() == 0) {
                throw new AuthenticationServiceException("\u65e0\u6cd5\u53c2\u52a0\u4e00\u4e2a\u672a\u5ba1\u6838\u901a\u8fc7\u7684\u8003\u8bd5\uff01");
            }
            Date now = new Date();
            if (exam.getEffTime().after(now) || exam.getExpTime().before(now)) {
                throw new AuthenticationServiceException("\u4e0d\u5728\u8003\u8bd5\u65f6\u95f4\u8303\u56f4\u5185\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528\u51c6\u8003\u8bc1\uff01");
            }
            if (hist.getApproved() == 0) {
                throw new AuthenticationServiceException("\u8003\u8bd5\u7533\u8bf7\u672a\u5ba1\u6838\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
            if (hist.getApproved() == 2) {
                throw new AuthenticationServiceException("\u8003\u8bd5\u7533\u8bf7\u5ba1\u6838\u672a\u901a\u8fc7\uff0c\u4e0d\u80fd\u53c2\u52a0\u8003\u8bd5\uff01");
            }
            UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
            this.setDetails(request, authRequest);
            Authentication authentication = null;
            try {
                authentication = this.getAuthenticationManager().authenticate((Authentication)authRequest);
                UserInfo userInfo = (UserInfo)authentication.getPrincipal();
                userInfo.setHistId(hist.getHistId());
                userInfo.setExamId(hist.getExamId());
                userInfo.setExamPaperId(hist.getExamPaperId());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return authentication;
        }
        if ("1".equals(flag)) {
            throw new AuthenticationServiceException("\u51c6\u8003\u8bc1\u53f7\u7801\u9519\u8bef\uff01");
        }
        if (!"".equals(username) && "".equals(password)) {
            throw new AuthenticationServiceException("\u8bf7\u8f93\u5165\u5bc6\u7801\uff01");
        }
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        this.setDetails(request, authRequest);
        Authentication authentication = null;
        try {
            authentication = this.getAuthenticationManager().authenticate((Authentication)authRequest);
        }
        catch (Exception e) {
            throw new AuthenticationServiceException("\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef\uff01");
        }
        UserInfo userDetails = (UserInfo)authentication.getPrincipal();
        if (!userDetails.getRolesName().contains("ROLE_STUDENT")) {
            throw new AuthenticationServiceException("\u7ba1\u7406\u7528\u6237\u8bf7\u4ece\u540e\u53f0\u7ba1\u7406\u9875\u9762\u767b\u5f55\uff01");
        }
        return authentication;
    }

    protected void checkValidateCode(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String sessionValidateCode = this.obtainSessionValidateCode(session);
        String validateCodeParameter = this.obtainValidateCodeParameter(request);
        if (StringUtils.isEmpty((Object)validateCodeParameter) || !sessionValidateCode.equalsIgnoreCase(validateCodeParameter)) {
            throw new AuthenticationServiceException("\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
    }

    protected String obtainSeriNoParameter(HttpServletRequest request) {
        String obj = request.getParameter(SERI_NO);
        return null == obj ? "" : obj.toString().trim().toUpperCase();
    }

    protected String obtainFlagParameter(HttpServletRequest request) {
        String obj = request.getParameter(FLAG);
        return null == obj ? "" : obj.toString().trim().toUpperCase();
    }

    protected String obtainValidateCodeParameter(HttpServletRequest request) {
        String obj = request.getParameter(VALIDATE_CODE);
        return null == obj ? "" : obj.toString().trim().toUpperCase();
    }

    protected String obtainSessionValidateCode(HttpSession session) {
        return null;
    }

    protected String obtainPassword(HttpServletRequest request) {
        String obj = request.getParameter(PASSWORD);
        return null == obj ? "" : obj.toString();
    }

    protected String obtainUsername(HttpServletRequest request) {
        String obj = request.getParameter(USERNAME);
        return null == obj ? "" : obj.toString().trim().toLowerCase();
    }
}

