/*
 * Decompiled with CFR 0.152.
 */
package com.examstack.portal.service;

import com.examstack.common.domain.exam.Exam;
import com.examstack.common.domain.exam.ExamHistory;
import com.examstack.common.domain.exam.ExamPaper;
import com.examstack.common.util.Page;
import com.examstack.common.util.StringUtil;
import com.examstack.portal.persistence.ExamMapper;
import com.examstack.portal.persistence.ExamPaperMapper;
import com.examstack.portal.service.ExamService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="examService")
public class ExamServiceImpl
implements ExamService {
    @Autowired
    private ExamMapper examMapper;
    @Autowired
    private ExamPaperMapper examPaperMapper;

    public ExamHistory getUserExamHistBySeriNo(String seriNo, int approved) {
        return this.examMapper.getUserExamHistBySeriNo(seriNo, approved);
    }

    public Exam getExamById(int examId) {
        return this.examMapper.getExamById(examId);
    }

    public ExamHistory getUserExamHistByUserIdAndExamId(int userId, int examId, int ... approved) {
        if (approved != null && approved.length == 0) {
            approved = null;
        }
        return this.examMapper.getUserExamHistByUserIdAndExamId(userId, examId, approved);
    }

    public int addUserExamHist(int userId, int examId, int examPaperId, int approved) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
        try {
            ExamPaper examPaper = this.examPaperMapper.getExamPaperById(examPaperId);
            ExamHistory history = new ExamHistory();
            history.setExamId(examId);
            history.setExamPaperId(examPaperId);
            history.setContent(examPaper.getContent());
            history.setDuration(examPaper.getDuration());
            history.setApproved(approved);
            Date now = new Date();
            String seriNo = sdf.format(now) + StringUtil.format((int)userId, (int)3) + StringUtil.format((int)examId, (int)3);
            history.setSeriNo(seriNo);
            history.setUserId(userId);
            this.examMapper.addUserExamHist(history);
            return history.getHistId();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public ExamHistory getUserExamHistListByHistId(int histId) {
        return this.examMapper.getUserExamHistListByHistId(histId);
    }

    public List<Exam> getExamListToApply(int userId, Page<Exam> page) {
        return this.examMapper.getExamListToApply(userId, page);
    }

    public List<Exam> getExamListToStart(int userId, Page<Exam> page, int ... typeIdList) {
        if (typeIdList != null && typeIdList.length == 0) {
            typeIdList = null;
        }
        return this.examMapper.getExamListToStart(userId, typeIdList, page);
    }

    public List<Exam> getExamList(Page<Exam> page, int ... typeIdList) {
        if (typeIdList != null && typeIdList.length == 0) {
            typeIdList = null;
        }
        return this.examMapper.getExamList(typeIdList, page);
    }

    public List<ExamHistory> getUserExamHistByUserId(int userId, Page<ExamHistory> page, int ... typeIdList) {
        if (typeIdList != null && typeIdList.length == 0) {
            typeIdList = null;
        }
        return this.examMapper.getUserExamHistByUserId(userId, typeIdList, page);
    }
}

