/*
 * Decompiled with CFR 0.152.
 */
package com.examstack.portal.service;

import com.examstack.common.domain.exam.UserQuestionHistory;
import com.examstack.common.domain.question.QuestionStatistic;
import com.examstack.portal.persistence.QuestionHistoryMapper;
import com.examstack.portal.service.QuestionHistoryService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="questionHistoryService")
public class QuestionHistoryServiceImpl
implements QuestionHistoryService {
    @Autowired
    private QuestionHistoryMapper questionHistoryMapper;

    public void addUserQuestionHist(List<UserQuestionHistory> historyList) {
        this.questionHistoryMapper.addUserQuestionHist(historyList);
    }

    public void addUserQuestionHist(UserQuestionHistory ... history) {
        ArrayList<UserQuestionHistory> historyList = new ArrayList<UserQuestionHistory>();
        for (UserQuestionHistory h : history) {
            historyList.add(h);
        }
        this.questionHistoryMapper.addUserQuestionHist(historyList);
    }

    public Map<Integer, List<UserQuestionHistory>> getUserQuestionHist(int userId, int fieldId) {
        List histList = this.questionHistoryMapper.getUserQuestionHist(userId, fieldId);
        HashMap<Integer, List<UserQuestionHistory>> map = new HashMap<Integer, List<UserQuestionHistory>>();
        for (UserQuestionHistory hist : histList) {
            ArrayList<UserQuestionHistory> result = (ArrayList<UserQuestionHistory>)map.get(hist.getPointId());
            if (result == null) {
                result = new ArrayList<UserQuestionHistory>();
            }
            result.add(hist);
            map.put(hist.getPointId(), result);
        }
        return map;
    }

    public Map<Integer, QuestionStatistic> getQuestionHistStaticByFieldId(int fieldId, int userId) {
        List statisticList = this.questionHistoryMapper.getQuestionHistStaticByFieldId(fieldId, userId);
        HashMap<Integer, QuestionStatistic> map = new HashMap<Integer, QuestionStatistic>();
        for (QuestionStatistic statistic : statisticList) {
            map.put(statistic.getPointId(), statistic);
        }
        return map;
    }

    public Map<Integer, Map<Integer, QuestionStatistic>> getTypeQuestionHistStaticByFieldId(int fieldId, int userId) {
        List statisticList = this.questionHistoryMapper.getTypeQuestionHistStaticByFieldId(fieldId, userId);
        HashMap<Integer, Map<Integer, QuestionStatistic>> map = new HashMap<Integer, Map<Integer, QuestionStatistic>>();
        for (QuestionStatistic statistic : statisticList) {
            HashMap<Integer, QuestionStatistic> tmp = (HashMap<Integer, QuestionStatistic>)map.get(statistic.getPointId());
            if (tmp == null) {
                tmp = new HashMap<Integer, QuestionStatistic>();
            }
            tmp.put(statistic.getQuestionTypeId(), statistic);
            map.put(statistic.getPointId(), tmp);
        }
        return map;
    }
}

