/*
 * Decompiled with CFR 0.152.
 */
package com.examstack.portal.service;

import com.examstack.common.domain.question.Field;
import com.examstack.common.domain.question.KnowledgePoint;
import com.examstack.common.domain.question.Question;
import com.examstack.common.domain.question.QuestionQueryResult;
import com.examstack.common.domain.question.QuestionStatistic;
import com.examstack.common.domain.question.QuestionType;
import com.examstack.common.util.Page;
import com.examstack.portal.persistence.QuestionMapper;
import com.examstack.portal.service.QuestionService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="questionService")
public class QuestionServiceImpl
implements QuestionService {
    @Autowired
    private QuestionMapper questionMapper;

    public Map<Integer, QuestionType> getQuestionTypeMap() {
        HashMap<Integer, QuestionType> map = new HashMap<Integer, QuestionType>();
        List typeList = this.questionMapper.getQuestionTypeList();
        for (QuestionType type : typeList) {
            map.put(type.getId(), type);
        }
        return map;
    }

    public Question getQuestionByQuestionId(int questionId) {
        return this.questionMapper.getQuestionByQuestionId(questionId);
    }

    public List<QuestionQueryResult> getQuestionAnalysisListByPointIdAndTypeId(int typeId, int pointId) {
        return this.questionMapper.getQuestionAnalysisListByPointIdAndTypeId(typeId, pointId);
    }

    public List<Field> getAllField(Page<Field> page) {
        return this.questionMapper.getAllField(page);
    }

    public Map<Integer, KnowledgePoint> getKnowledgePointByFieldId(Page<KnowledgePoint> page, int ... fieldIdList) {
        HashMap<Integer, KnowledgePoint> map = new HashMap<Integer, KnowledgePoint>();
        if (fieldIdList != null && fieldIdList.length == 0) {
            fieldIdList = null;
        }
        List pointList = this.questionMapper.getKnowledgePointByFieldId(fieldIdList, page);
        for (KnowledgePoint point : pointList) {
            map.put(point.getPointId(), point);
        }
        return map;
    }

    public Map<Integer, Map<Integer, List<QuestionQueryResult>>> getQuestionMapByFieldId(int fieldId, Page<QuestionQueryResult> page) {
        List questionList = this.questionMapper.getQuestionListByFieldId(fieldId, page);
        HashMap<Integer, Map<Integer, List<QuestionQueryResult>>> map = new HashMap<Integer, Map<Integer, List<QuestionQueryResult>>>();
        for (QuestionQueryResult result : questionList) {
            ArrayList<QuestionQueryResult> tmpList;
            HashMap<Integer, ArrayList<QuestionQueryResult>> tmpMap = (HashMap<Integer, ArrayList<QuestionQueryResult>>)map.get(result.getKnowledgePointId());
            if (tmpMap == null) {
                tmpMap = new HashMap<Integer, ArrayList<QuestionQueryResult>>();
            }
            if ((tmpList = (ArrayList<QuestionQueryResult>)tmpMap.get(result.getQuestionTypeId())) == null) {
                tmpList = new ArrayList<QuestionQueryResult>();
            }
            tmpList.add(result);
            tmpMap.put(result.getQuestionTypeId(), tmpList);
            map.put(result.getKnowledgePointId(), tmpMap);
        }
        return map;
    }

    public List<QuestionQueryResult> getQuestionAnalysisListByIdList(List<Integer> idList) {
        return this.questionMapper.getQuestionAnalysisListByIdList(idList);
    }

    public Map<Integer, QuestionStatistic> getQuestionStaticByFieldId(int fieldId) {
        List statisticList = this.questionMapper.getQuestionStaticByFieldId(fieldId);
        HashMap<Integer, QuestionStatistic> map = new HashMap<Integer, QuestionStatistic>();
        for (QuestionStatistic statistic : statisticList) {
            map.put(statistic.getPointId(), statistic);
        }
        return map;
    }

    public Map<Integer, Map<Integer, QuestionStatistic>> getTypeQuestionStaticByFieldId(int fieldId) {
        List statisticList = this.questionMapper.getTypeQuestionStaticByFieldId(fieldId);
        HashMap<Integer, Map<Integer, QuestionStatistic>> map = new HashMap<Integer, Map<Integer, QuestionStatistic>>();
        for (QuestionStatistic statistic : statisticList) {
            HashMap<Integer, QuestionStatistic> tmp = (HashMap<Integer, QuestionStatistic>)map.get(statistic.getPointId());
            if (tmp == null) {
                tmp = new HashMap<Integer, QuestionStatistic>();
            }
            tmp.put(statistic.getQuestionTypeId(), statistic);
            map.put(statistic.getPointId(), tmp);
        }
        return map;
    }
}

